

<?php $__env->startSection('content'); ?>
    <div class="flex h-[calc(100vh-64px)] overflow-hidden bg-gray-900" x-data="posSystem()">
        <!-- Left Side: Products Grid -->
        <div class="w-2/3 flex flex-col border-r border-gray-700">
            <!-- Search Bar -->
            <div class="p-4 bg-gray-800 border-b border-gray-700">
                <input type="text" x-model="searchQuery" placeholder="Buscar productos..."
                    class="w-full px-4 py-2 bg-gray-700 text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-amber-500">
            </div>

            <!-- Categories -->
            <div
                class="h-16 bg-gray-800 border-b border-gray-700 flex overflow-x-auto whitespace-nowrap p-2 items-center space-x-2">
                <button @click="selectedCategory = 'all'"
                    :class="{'bg-amber-600 text-white': selectedCategory === 'all', 'bg-gray-700 text-gray-300': selectedCategory !== 'all'}"
                    class="px-4 py-1 rounded-full text-sm font-medium transition">
                    Todas
                </button>
                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <button @click="selectedCategory = <?php echo e($category->id); ?>"
                        :class="{'bg-amber-600 text-white': selectedCategory === <?php echo e($category->id); ?>, 'bg-gray-700 text-gray-300': selectedCategory !== <?php echo e($category->id); ?>}"
                        class="px-4 py-1 rounded-full text-sm font-medium transition">
                        <?php echo e($category->name); ?>

                    </button>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <!-- Product Grid -->
            <div class="flex-1 overflow-y-auto p-4 bg-gray-900">
                <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-4">
                    <?php $__currentLoopData = $allProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div @click="addToCart(<?php echo e($product); ?>)"
                            x-show="filterProduct(<?php echo e($product->category_id); ?>, '<?php echo e(strtolower($product->name)); ?>')"
                            class="bg-gray-800 rounded-lg p-4 cursor-pointer hover:bg-gray-700 border border-gray-700 flex flex-col justify-between transition h-32">
                            <div>
                                <h4 class="text-white font-medium text-sm truncate"><?php echo e($product->name); ?></h4>
                                <p class="text-xs text-gray-400"><?php echo e($product->category->name); ?></p>
                            </div>
                            <div>
                                <span class="text-amber-500 font-bold">$<?php echo e(number_format($product->sale_price, 2)); ?></span>
                                <p class="text-[10px] text-gray-500 mt-1">Stock: <?php echo e($product->stock); ?></p>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>

        <!-- Right Side: Cart -->
        <div class="w-1/3 flex flex-col bg-gray-800">
            <div class="p-4 border-b border-gray-700 bg-gray-900">
                <h2 class="text-xl font-bold text-white flex items-center">
                    <svg class="h-6 w-6 mr-2 text-amber-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z">
                        </path>
                    </svg>
                    Carrito de Compra
                </h2>
            </div>

            <!-- Cart Items -->
            <div class="flex-1 overflow-y-auto p-4 space-y-3">
                <template x-if="cart.length === 0">
                    <div class="text-center text-gray-500 mt-10">
                        <p>El carrito está vacío</p>
                    </div>
                </template>
                <template x-for="(item, index) in cart" :key="index">
                    <div class="flex justify-between items-center bg-gray-700 p-3 rounded-lg border border-gray-600">
                        <div class="flex-1">
                            <h5 class="text-white font-medium text-sm" x-text="item.name"></h5>
                            <p class="text-amber-500 text-xs">$<span x-text="item.price.toFixed(2)"></span></p>
                        </div>
                        <div class="flex items-center space-x-3">
                            <button @click="updateQuantity(index, -1)"
                                class="w-6 h-6 rounded bg-gray-600 text-white hover:bg-red-600 flex items-center justify-center">-</button>
                            <span class="text-white font-mono w-4 text-center" x-text="item.quantity"></span>
                            <button @click="updateQuantity(index, 1)"
                                class="w-6 h-6 rounded bg-gray-600 text-white hover:bg-green-600 flex items-center justify-center">+</button>
                        </div>
                        <div class="ml-4 text-right">
                            <p class="text-white font-bold text-sm">$<span
                                    x-text="(item.price * item.quantity).toFixed(2)"></span></p>
                        </div>
                    </div>
                </template>
            </div>

            <!-- Totals & Checkout -->
            <div class="p-4 bg-gray-900 border-t border-gray-700">
                <div class="flex justify-between mb-2">
                    <span class="text-gray-400">Subtotal</span>
                    <span class="text-white font-mono">$<span x-text="cartTotal.toFixed(2)"></span></span>
                </div>
                <div class="flex justify-between mb-4">
                    <span class="text-xl font-bold text-white">Total</span>
                    <span class="text-2xl font-bold text-amber-500 font-mono">$<span
                            x-text="cartTotal.toFixed(2)"></span></span>
                </div>

                <button @click="showCheckoutModal = true" :disabled="cart.length === 0"
                    class="w-full py-3 bg-amber-600 hover:bg-amber-700 text-white rounded-lg font-bold text-lg disabled:opacity-50 disabled:cursor-not-allowed transition">
                    Cobrar
                </button>
            </div>
        </div>

        <!-- Checkout Modal -->
        <div x-show="showCheckoutModal" class="fixed z-50 inset-0 overflow-y-auto hidden"
            :class="{'hidden': !showCheckoutModal}">
            <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
                <div class="fixed inset-0 bg-gray-900 bg-opacity-90 transition-opacity" @click="showCheckoutModal = false">
                </div>
                <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>
                <div
                    class="inline-block align-bottom bg-gray-800 rounded-lg px-4 pt-5 pb-4 text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full sm:p-6 border border-gray-700">
                    <div class="sm:flex sm:items-start">
                        <div
                            class="mx-auto flex-shrink-0 flex items-center justify-center h-12 w-12 rounded-full bg-green-100 sm:mx-0 sm:h-10 sm:w-10">
                            <svg class="h-6 w-6 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z">
                                </path>
                            </svg>
                        </div>
                        <div class="mt-3 text-center sm:mt-0 sm:ml-4 sm:text-left w-full">
                            <h3 class="text-lg leading-6 font-medium text-white" id="modal-title">Procesar Pago</h3>

                            <div class="mt-4 space-y-4">
                                <div>
                                    <p class="text-sm text-gray-400">Total a Pagar:</p>
                                    <p class="text-3xl font-bold text-amber-500 text-center my-2 font-mono">$<span
                                            x-text="cartTotal.toFixed(2)"></span></p>
                                </div>

                                <div>
                                    <label class="block text-sm font-medium text-gray-300">Método de Pago</label>
                                    <div class="mt-2 grid grid-cols-2 gap-2">
                                        <button @click="paymentMethod = 'cash'"
                                            :class="{'bg-amber-600 text-white': paymentMethod === 'cash', 'bg-gray-700 text-gray-300': paymentMethod !== 'cash'}"
                                            class="px-4 py-2 rounded-md text-sm font-medium border border-gray-600">Efectivo</button>
                                        <button @click="paymentMethod = 'card'"
                                            :class="{'bg-amber-600 text-white': paymentMethod === 'card', 'bg-gray-700 text-gray-300': paymentMethod !== 'card'}"
                                            class="px-4 py-2 rounded-md text-sm font-medium border border-gray-600">Tarjeta</button>
                                        <button @click="paymentMethod = 'transfer'"
                                            :class="{'bg-amber-600 text-white': paymentMethod === 'transfer', 'bg-gray-700 text-gray-300': paymentMethod !== 'transfer'}"
                                            class="px-4 py-2 rounded-md text-sm font-medium border border-gray-600">Transferencia</button>
                                        <button @click="paymentMethod = 'other'"
                                            :class="{'bg-amber-600 text-white': paymentMethod === 'other', 'bg-gray-700 text-gray-300': paymentMethod !== 'other'}"
                                            class="px-4 py-2 rounded-md text-sm font-medium border border-gray-600">Otro</button>
                                    </div>
                                </div>

                                <div x-show="paymentMethod === 'cash'">
                                    <label class="block text-sm font-medium text-gray-300">Monto Recibido</label>
                                    <input type="number" x-model.number="amountPaid"
                                        class="mt-1 block w-full px-3 py-2 bg-gray-700 border border-gray-600 rounded-md text-white shadow-sm focus:outline-none focus:ring-amber-500 focus:border-amber-500 sm:text-lg"
                                        placeholder="0.00">

                                    <div class="mt-2 flex justify-between items-center bg-gray-900 p-2 rounded">
                                        <span class="text-gray-400 text-sm">Cambio:</span>
                                        <span class="text-white font-bold font-mono text-lg"
                                            :class="{'text-red-500': calculateChange() < 0, 'text-green-500': calculateChange() >= 0}">$<span
                                                x-text="calculateChange().toFixed(2)"></span></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="mt-5 sm:mt-4 sm:flex sm:flex-row-reverse">
                        <button @click="processSale()"
                            :disabled="isLoading || (paymentMethod === 'cash' && amountPaid < cartTotal)"
                            class="w-full inline-flex justify-center rounded-md border border-transparent shadow-sm px-4 py-2 bg-amber-600 text-base font-medium text-white hover:bg-amber-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-amber-500 sm:ml-3 sm:w-auto sm:text-sm disabled:opacity-50 disabled:cursor-not-allowed">
                            <span x-show="!isLoading">Confirmar Venta</span>
                            <span x-show="isLoading">Procesando...</span>
                        </button>
                        <button @click="showCheckoutModal = false" type="button"
                            class="mt-3 w-full inline-flex justify-center rounded-md border border-gray-300 shadow-sm px-4 py-2 bg-gray-800 text-base font-medium text-gray-300 hover:text-white hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 sm:mt-0 sm:w-auto sm:text-sm">
                            Cancelar
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js" defer></script>
    <script>
        function posSystem() {
            return {
                searchQuery: '',
                selectedCategory: 'all',
                cart: [],
                showCheckoutModal: false,
                paymentMethod: 'cash',
                amountPaid: 0,
                isLoading: false,

                get cartTotal() {
                    return this.cart.reduce((total, item) => total + (item.price * item.quantity), 0);
                },

                filterProduct(categoryId, productName) {
                    const categoryMatch = this.selectedCategory === 'all' || this.selectedCategory === categoryId;
                    const nameMatch = productName.includes(this.searchQuery.toLowerCase());
                    return categoryMatch && nameMatch;
                },

                addToCart(product) {
                    const existingItem = this.cart.find(item => item.id === product.id);
                    if (existingItem) {
                        if (existingItem.quantity < product.stock) {
                            existingItem.quantity++;
                        } else {
                            alert('Stock máximo alcanzado');
                        }
                    } else {
                        if (product.stock > 0) {
                            this.cart.push({
                                id: product.id,
                                name: product.name,
                                price: parseFloat(product.sale_price),
                                quantity: 1,
                                maxStock: product.stock
                            });
                        } else {
                            alert('Producto sin stock');
                        }
                    }
                },

                updateQuantity(index, change) {
                    const item = this.cart[index];
                    const newQuantity = item.quantity + change;
                    if (newQuantity > 0 && newQuantity <= item.maxStock) {
                        item.quantity = newQuantity;
                    } else if (newQuantity <= 0) {
                        this.cart.splice(index, 1);
                    } else {
                        alert('Stock máximo alcanzado');
                    }
                },

                calculateChange() {
                    if (this.paymentMethod !== 'cash') return 0;
                    return Math.max(0, this.amountPaid - this.cartTotal);
                },

                processSale() {
                    this.isLoading = true;

                    fetch('<?php echo e(route("pos.store")); ?>', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                        },
                        body: JSON.stringify({
                            cart: this.cart,
                            payment_method: this.paymentMethod,
                            amount_paid: this.paymentMethod === 'cash' ? this.amountPaid : null
                        })
                    })
                        .then(response => response.json())
                        .then(data => {
                            if (data.success) {
                                alert('Venta realizada con éxito. Cambio: $' + data.change.toFixed(2));
                                this.cart = [];
                                this.showCheckoutModal = false;
                                this.amountPaid = 0;
                                window.location.reload(); // To update stock in frontend
                            } else {
                                alert('Error: ' + data.message);
                            }
                        })
                        .catch(error => {
                            console.error('Error:', error);
                            alert('Ocurrió un error al procesar la venta.');
                        })
                        .finally(() => {
                            this.isLoading = false;
                        });
                }
            }
        }
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\SukhaCigarBar\resources\views/pos/index.blade.php ENDPATH**/ ?>