

<?php $__env->startSection('content'); ?>
    <div class="max-w-7xl mx-auto py-6 sm:px-6 lg:px-8 h-[calc(100vh-65px)] flex flex-col md:flex-row gap-6" x-data="posCart({
                                                            initialItems: <?php echo e(json_encode($mesa->activeOrder->detalles->where('estado', 'activo')->map(fn($d) => [
        'id' => $d->id,
        'name' => $d->product->name,
        'cantidad' => $d->cantidad,
        'precio_unitario' => (float) $d->precio_unitario,
        'subtotal' => (float) $d->subtotal,
        'observaciones' => $d->observaciones
    ])->values())); ?>,
                                                            initialTotal: <?php echo e((float) $mesa->activeOrder->total); ?>,
                                                            initialCliente: <?php echo e(json_encode($mesa->activeOrder->cliente ?? '')); ?>,
                                                            addItemUrl: '<?php echo e(route('pos.order.addItem', $mesa->activeOrder)); ?>',
                                                            removeItemUrlBase: '<?php echo e(url('/pos/order/item')); ?>',
                                                            updateClienteUrl: '<?php echo e(route('pos.order.updateCliente', $mesa->activeOrder)); ?>',
                                                            orderId: <?php echo e($mesa->activeOrder->id); ?>

                                                        })">

        <!-- LEFT: Order Details & Actions -->
        <div class="w-full md:w-1/3 bg-gray-800 rounded-lg shadow-xl p-4 flex flex-col h-full">
            <div class="flex justify-between items-center border-b border-gray-700 pb-4 mb-4 shrink-0">
                <div>
                    <h2 class="text-2xl font-bold text-white flex items-center gap-2">
                        <?php echo e($mesa->name); ?>

                        <template x-if="clienteLabel">
                            <span class="text-amber-500" x-text="'- ' + clienteLabel"></span>
                        </template>
                        <button type="button" @click="openRenameModal()"
                            class="ml-1 text-gray-500 hover:text-amber-400 transition" title="Editar nombre de cliente">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
                                <path
                                    d="M13.586 3.586a2 2 0 112.828 2.828l-.793.793-2.828-2.828.793-.793zM11.379 5.793L3 14.172V17h2.828l8.38-8.379-2.83-2.828z" />
                            </svg>
                        </button>
                    </h2>
                    <span class="text-sm text-gray-400">Orden #<?php echo e($mesa->activeOrder->id); ?></span>
                </div>
                <div class="text-right">
                    <span class="block text-2xl font-bold text-green-400" x-text="formatMoney(total)">RD$
                        <?php echo e(number_format($mesa->activeOrder->total, 2)); ?></span>
                    <span class="text-xs text-gray-500">Total</span>
                </div>
            </div>

            <!-- Order Items List -->
            <div class="flex-1 overflow-y-auto space-y-3 mb-4 custom-scrollbar">
                <template x-for="item in items" :key="item.id">
                    <div
                        class="flex justify-between items-center bg-gray-700 p-3 rounded shrink-0 transition-all hover:bg-gray-650">
                        <div>
                            <div class="text-white font-medium" x-text="item.name"></div>
                            <div class="text-xs text-gray-400">
                                <span x-text="item.cantidad"></span> x <span
                                    x-text="formatMoney(item.precio_unitario)"></span>
                            </div>
                            <template x-if="item.observaciones">
                                <div class="text-xs text-yellow-500 italic" x-text="item.observaciones"></div>
                            </template>
                        </div>
                        <div class="flex items-center gap-3">
                            <span class="text-white font-bold" x-text="formatMoney(item.subtotal)"></span>
                            <?php if(auth()->user()->isAdmin()): ?>
                                <button @click="removeItem(item.id)" class="text-red-400 hover:text-red-300 disabled:opacity-50"
                                    :disabled="processing">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20"
                                        fill="currentColor">
                                        <path fill-rule="evenodd"
                                            d="M9 2a1 1 0 00-.894.553L7.382 4H4a1 1 0 000 2v10a2 2 0 002 2h8a2 2 0 002-2V6a1 1 0 100-2h-3.382l-.724-1.447A1 1 0 0011 2H9zM7 8a1 1 0 012 0v6a1 1 0 11-2 0V8zm5-1a1 1 0 00-1 1v6a1 1 0 102 0V8a1 1 0 00-1-1z"
                                            clip-rule="evenodd" />
                                    </svg>
                                </button>
                            <?php endif; ?>
                        </div>
                    </div>
                </template>
                <div x-show="items.length === 0" class="text-center py-10 text-gray-500 italic text-sm">
                    No hay productos añadidos
                </div>
            </div>

            <!-- Actions -->
            <div class="mt-auto space-y-2 shrink-0">
                <div class="grid grid-cols-2 gap-2 mb-2">
                    <form action="<?php echo e(route('pos.order.precheck', $mesa->activeOrder)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <button type="submit"
                            class="w-full bg-blue-600 hover:bg-blue-500 text-white font-bold py-3 rounded text-sm shadow">
                            Imprimir Ticket
                        </button>
                    </form>
                    <a href="<?php echo e(route('pos.order.print-browser', $mesa->activeOrder)); ?>" target="_blank"
                        class="flex items-center justify-center w-full bg-gray-700 hover:bg-gray-600 text-white font-bold py-3 rounded text-sm shadow">
                        Imprimir (Navegador)
                    </a>
                </div>

                <button @click="openCheckout()"
                    class="w-full bg-green-600 hover:bg-green-500 text-white font-bold py-3 rounded text-lg shadow">
                    Cobrar / Cerrar Mesa
                </button>
                <button @click="openSplitModal()"
                    class="w-full bg-amber-600 hover:bg-amber-500 text-white font-bold py-3 rounded text-lg shadow mb-2">
                    Dividir Cuenta
                </button>

                <div class="grid grid-cols-2 gap-2">
                    <?php if(auth()->user()->isAdmin()): ?>
                        <form action="<?php echo e(route('pos.order.cancel', $mesa->activeOrder)); ?>" method="POST"
                            onsubmit="return confirm('¿Anular esta orden y liberar la mesa?')">
                            <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                            <button type="submit"
                                class="w-full bg-red-600 hover:bg-red-500 text-white font-bold py-2 rounded text-sm shadow">
                                Anular Orden
                            </button>
                        </form>
                    <?php endif; ?>
                    <a href="<?php echo e(route('pos.map')); ?>"
                        class="flex items-center justify-center w-full bg-gray-600 hover:bg-gray-500 text-white font-bold py-2 rounded text-sm transition">
                        Volver al Mapa
                    </a>
                </div>
            </div>
        </div>

        <!-- RIGHT: Product Selection -->
        <div class="w-full md:w-2/3 bg-gray-800 rounded-lg shadow-xl p-4 flex flex-col h-full">
            <div class="flex flex-col md:flex-row md:items-center justify-between gap-4 mb-4 shrink-0">
                <h3 class="text-xl font-bold text-white">Catálogo de Productos</h3>
                <div class="relative w-full md:w-64">
                    <input type="text" x-model.debounce.300ms="searchQuery" @input="searchProducts()"
                        placeholder="Buscar producto..."
                        class="w-full bg-gray-900 border border-gray-700 rounded-lg py-2 pl-10 pr-4 text-white focus:ring-2 focus:ring-amber-500 outline-none text-sm">
                    <div class="absolute left-3 top-2.5 text-gray-500">
                        <i class="bi bi-search"></i>
                    </div>
                    <div x-show="searching" class="absolute right-3 top-2.5">
                        <div class="animate-spin rounded-full h-4 w-4 border-b-2 border-amber-500"></div>
                    </div>
                </div>
            </div>

            <?php
                $iconMap = [
                    'cigarros' => 'bi-fire',
                    'puros' => 'bi-fire',
                    'bebidas espirituosas' => 'bi-cup-straw',
                    'bebidas' => 'bi-cup-straw',
                    'vinos' => 'bi-glass-base',
                    'coctelería' => 'bi-cup-hot',
                    'snacks' => 'bi-egg-fried',
                    'comida' => 'bi-egg-fried',
                    'cigar' => 'bi-fire',
                    'drink' => 'bi-cup-straw',
                    'food' => 'bi-egg-fried',
                    'wine' => 'bi-glass-base',
                    'coffee' => 'bi-cup-hot',
                ];
            ?>

            <!-- Category Filter Tabs -->
            <div class="flex flex-wrap gap-2 mb-4 shrink-0 overflow-x-auto pb-2 custom-scrollbar">
                <button @click="activeCategoryId = 'all'"
                    :class="activeCategoryId === 'all' ? 'bg-amber-600 text-white' : 'bg-gray-700 text-gray-300 hover:bg-gray-600'"
                    class="px-4 py-2 rounded-full text-sm font-bold transition-colors whitespace-nowrap">
                    Todo
                </button>
                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <button @click="activeCategoryId = <?php echo e($category->id); ?>"
                        :class="activeCategoryId === <?php echo e($category->id); ?> ? 'bg-amber-600 text-white' : 'bg-gray-700 text-gray-300 hover:bg-gray-600'"
                        class="px-4 py-2 rounded-full text-sm font-bold transition-colors whitespace-nowrap flex items-center gap-2">
                        <i
                            class="bi <?php echo e($iconMap[strtolower($category->name)] ?? ($iconMap[$category->icon] ?? 'bi-tag')); ?>"></i>
                        <?php echo e($category->name); ?>

                    </button>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <div class="flex-1 overflow-y-auto custom-scrollbar">
                <!-- Search Results -->
                <div x-show="searchQuery.length > 0">
                    <template x-if="searchResults.length === 0 && !searching">
                        <div class="text-center py-10 text-gray-500 italic">
                            No se encontraron productos para "<span x-text="searchQuery"></span>"
                        </div>
                    </template>
                    <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-4 pb-4">
                        <template x-for="product in searchResults" :key="product.id">
                            <div class="h-40" x-transition>
                                <button type="button" @click="addItem(product.id)"
                                    class="w-full h-full bg-gray-700 hover:bg-gray-600 p-4 rounded-lg flex flex-col items-center justify-between group transition-colors border border-transparent hover:border-amber-500 relative"
                                    :disabled="processing">
                                    <div class="text-amber-500 mb-2 opacity-80 group-hover:opacity-100 transition-opacity">
                                        <i
                                            :class="'bi ' + (iconMap[product.category?.name?.toLowerCase()] || 'bi-box') + ' text-3xl'"></i>
                                    </div>
                                    <span
                                        class="text-center text-white font-medium group-hover:text-amber-400 line-clamp-2 text-sm"
                                        x-text="product.name"></span>
                                    <span class="text-green-400 font-bold mt-1 text-xs"
                                        x-text="'RD$ ' + parseFloat(product.sale_price).toLocaleString()"></span>

                                    <!-- Indicator -->
                                    <div x-show="pendingItems.includes(product.id)"
                                        class="absolute inset-0 bg-gray-900 bg-opacity-50 rounded-lg flex items-center justify-center">
                                        <div class="animate-spin rounded-full h-8 w-8 border-b-2 border-amber-500"></div>
                                    </div>
                                </button>
                            </div>
                        </template>
                    </div>
                </div>

                <!-- Category View -->
                <div x-show="searchQuery.length === 0">
                    <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-4 pb-4">
                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php $__currentLoopData = $category->products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="h-40" x-show="activeCategoryId === 'all' || activeCategoryId === <?php echo e($category->id); ?>"
                                    x-transition>
                                    <button type="button" @click="addItem(<?php echo e($product->id); ?>)"
                                        class="w-full h-full bg-gray-700 hover:bg-gray-600 p-4 rounded-lg flex flex-col items-center justify-between group transition-colors border border-transparent hover:border-amber-500 relative"
                                        :disabled="processing">
                                        <div class="text-amber-500 mb-2 opacity-80 group-hover:opacity-100 transition-opacity">
                                            <i
                                                class="bi <?php echo e($iconMap[strtolower($category->name)] ?? ($iconMap[$category->icon] ?? 'bi-box')); ?> text-3xl"></i>
                                        </div>
                                        <span
                                            class="text-center text-white font-medium group-hover:text-amber-400 line-clamp-2 text-sm"><?php echo e($product->name); ?></span>
                                        <span class="text-green-400 font-bold mt-1 text-xs">RD$
                                            <?php echo e(number_format($product->sale_price, 0)); ?></span>

                                        <!-- Indicator -->
                                        <div x-show="pendingItems.includes(<?php echo e($product->id); ?>)"
                                            class="absolute inset-0 bg-gray-900 bg-opacity-50 rounded-lg flex items-center justify-center">
                                            <div class="animate-spin rounded-full h-8 w-8 border-b-2 border-amber-500"></div>
                                        </div>
                                    </button>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Checkout Modal -->
        <dialog id="checkoutModal"
            class="bg-gray-800 text-white p-0 rounded-lg shadow-2xl backdrop:bg-black backdrop:bg-opacity-70 border border-gray-700">
            <div class="w-[450px]" x-data="{ 
                                                                    total_p: 0, 
                                                                    paid: 0, 
                                                                    discount: 0,
                                                                    method: 'cash',
                                                                    get net_total() { return Math.max(0, this.total_p - this.discount) },
                                                                    get change() { return Math.max(0, this.paid - this.net_total).toFixed(2) }
                                                                }"
                x-on:show-checkout.window="total_p = $event.detail.total; paid = $event.detail.total; discount = 0">

                <div class="bg-gray-700 px-6 py-4 flex justify-between items-center border-b border-gray-600">
                    <h3 class="text-xl font-bold">Cobrar & Finalizar Mesa</h3>
                    <button onclick="document.getElementById('checkoutModal').close()"
                        class="text-gray-400 hover:text-white">&times;</button>
                </div>

                <form action="<?php echo e(route('pos.order.close', $mesa->activeOrder)); ?>" method="POST" class="p-6">
                    <?php echo csrf_field(); ?>

                    <div class="grid grid-cols-2 gap-4 mb-6">
                        <div class="bg-gray-900 bg-opacity-50 p-4 rounded-lg border border-gray-700">
                            <span class="text-gray-400 text-sm block mb-1">Total a Pagar</span>
                            <span class="text-3xl font-bold text-amber-500"
                                x-text="'RD$ ' + parseFloat(net_total).toLocaleString(undefined, {minimumFractionDigits: 2})"></span>
                            <template x-if="discount > 0">
                                <span class="text-xs text-red-400 block" x-text="'Desc. RD$ ' + discount"></span>
                            </template>
                        </div>
                        <div class="bg-green-900 bg-opacity-30 p-4 rounded-lg border border-green-800">
                            <span class="text-green-400 text-sm block mb-1">Su Cambio (Devuelta)</span>
                            <span class="text-3xl font-bold text-green-400" x-text="'RD$ ' + change">RD$ 0.00</span>
                        </div>
                    </div>

                    <div class="mb-4">
                        <label class="block text-gray-400 text-sm font-bold mb-2 uppercase">Método de Pago</label>
                        <div class="grid grid-cols-3 gap-2">
                            <label class="cursor-pointer">
                                <input type="radio" name="payment_method" value="cash" x-model="method" class="hidden peer">
                                <div
                                    class="bg-gray-700 peer-checked:bg-amber-600 peer-checked:text-white p-2 rounded text-center transition-colors">
                                    Efectivo</div>
                            </label>
                            <label class="cursor-pointer">
                                <input type="radio" name="payment_method" value="card" x-model="method" class="hidden peer">
                                <div
                                    class="bg-gray-700 peer-checked:bg-amber-600 peer-checked:text-white p-2 rounded text-center transition-colors">
                                    Tarjeta</div>
                            </label>
                            <label class="cursor-pointer">
                                <input type="radio" name="payment_method" value="transfer" x-model="method"
                                    class="hidden peer">
                                <div
                                    class="bg-gray-700 peer-checked:bg-amber-600 peer-checked:text-white p-2 rounded text-center transition-colors">
                                    Transf.</div>
                            </label>
                        </div>
                    </div>

                    <div class="mb-6" x-show="method === 'cash'" x-transition>
                        <label class="block text-gray-400 text-sm font-bold mb-2 uppercase">Monto Recibido</label>
                        <input type="number" name="amount_paid" x-model.number="paid" step="0.01"
                            class="w-full bg-gray-900 border border-gray-700 rounded-lg p-3 text-2xl font-bold text-green-400 focus:ring-2 focus:ring-amber-500 outline-none"
                            placeholder="0.00">

                        <div class="flex gap-2 mt-4">
                            <button type="button" @click="paid = 100"
                                class="flex-1 bg-gray-700 hover:bg-gray-600 py-2 rounded text-sm">$100</button>
                            <button type="button" @click="paid = 500"
                                class="flex-1 bg-gray-700 hover:bg-gray-600 py-2 rounded text-sm">$500</button>
                            <button type="button" @click="paid = 1000"
                                class="flex-1 bg-gray-700 hover:bg-gray-600 py-2 rounded text-sm">$1000</button>
                            <button type="button" @click="paid = 2000"
                                class="flex-1 bg-gray-700 hover:bg-gray-600 py-2 rounded text-sm">$2000</button>
                        </div>
                    </div>

                    <?php if(auth()->user()->isAdmin()): ?>
                        <div class="mb-6 bg-amber-900/10 p-4 rounded-lg border border-amber-900/30">
                            <label class="block text-amber-500 text-sm font-bold mb-2 uppercase flex justify-between">
                                Descuento Especial (Admin)
                                <template x-if="discount > 0">
                                    <span class="text-xs" x-text="((discount / total_p) * 100).toFixed(0) + '%'"></span>
                                </template>
                            </label>
                            <input type="number" name="discount" x-model.number="discount" step="0.01"
                                class="w-full bg-gray-900 border border-amber-900/50 rounded-lg p-2 text-xl font-bold text-amber-500 focus:ring-2 focus:ring-amber-500 outline-none"
                                placeholder="0.00">
                        </div>
                    <?php endif; ?>

                    <div class="flex flex-col gap-3">
                        <button type="submit"
                            class="w-full bg-green-600 hover:bg-green-500 text-white font-bold py-4 rounded-xl text-xl shadow-lg transition transform active:scale-95">
                            REGISTRAR PAGO & CERRAR
                        </button>
                        <button type="button" onclick="document.getElementById('checkoutModal').close()"
                            class="w-full text-gray-400 hover:text-white py-2 transition">
                            Volver a la orden
                        </button>
                    </div>
                </form>
            </div>
        </dialog>

        <!-- Split Billing Modal (Amount / People) -->
        <dialog id="splitModal"
            class="bg-gray-800 text-white p-0 rounded-lg shadow-2xl backdrop:bg-black backdrop:bg-opacity-70 border border-gray-700">
            <div class="w-[500px]" x-data="{ 
                                                                    method: 'cash',
                                                                    people: 1,
                                                                    discount: 0,
                                                                    customAmount: 0,
                                                                    totalOrder: 0,
                                                                    paidAmount: 0,
                                                                    receivedAmount: 0,
                                                                    splitType: 'people', // 'people' or 'custom'

                                                                    get remaining() { return Math.max(0, this.totalOrder - this.paidAmount); },
                                                                    get amountPerPerson() { return (this.remaining / Math.max(1, this.people)).toFixed(2); },
                                                                    get payAmount() { 
                                                                        const base = this.splitType === 'people' ? this.amountPerPerson : this.customAmount;
                                                                        return Math.max(0, base - this.discount);
                                                                    },
                                                                    get change() { return Math.max(0, this.receivedAmount - this.payAmount).toFixed(2); }
                                                                }"
                x-on:open-split.window="totalOrder = $event.detail.total; paidAmount = $event.detail.paid; people = 1; customAmount = 0; receivedAmount = 0; splitType = 'people'; discount = 0">

                <div class="bg-amber-900/40 px-6 py-4 flex justify-between items-center border-b border-amber-900/50">
                    <h3 class="text-xl font-bold text-amber-500">Dividir Cuenta / Pago Parcial</h3>
                    <button onclick="document.getElementById('splitModal').close()"
                        class="text-gray-400 hover:text-white">&times;</button>
                </div>

                <div class="p-6">
                    <!-- Summary Cards -->
                    <div class="grid grid-cols-3 gap-3 mb-6">
                        <div class="bg-gray-900 p-3 rounded border border-gray-700 text-center">
                            <span class="text-xs text-gray-500 block uppercase">Total Orden</span>
                            <span class="text-lg font-bold text-white"
                                x-text="'$' + parseFloat(totalOrder).toLocaleString()"></span>
                        </div>
                        <div class="bg-gray-900 p-3 rounded border border-gray-700 text-center">
                            <span class="text-xs text-gray-500 block uppercase">Pagado</span>
                            <span class="text-lg font-bold text-green-400"
                                x-text="'$' + parseFloat(paidAmount).toLocaleString()"></span>
                        </div>
                        <div class="bg-gray-900 p-3 rounded border border-gray-700 text-center">
                            <span class="text-xs text-gray-500 block uppercase">Restante</span>
                            <span class="text-lg font-bold text-amber-500"
                                x-text="'$' + parseFloat(remaining).toLocaleString()"></span>
                        </div>
                    </div>

                    <!-- Split Type Selector -->
                    <div class="flex mb-4 bg-gray-700 rounded p-1">
                        <button @click="splitType = 'people'"
                            :class="splitType === 'people' ? 'bg-amber-600 text-white shadow' : 'text-gray-400'"
                            class="flex-1 py-2 rounded text-sm font-bold transition">
                            Entre Personas
                        </button>
                        <button @click="splitType = 'custom'; customAmount = 0"
                            :class="splitType === 'custom' ? 'bg-amber-600 text-white shadow' : 'text-gray-400'"
                            class="flex-1 py-2 rounded text-sm font-bold transition">
                            Monto Manual
                        </button>
                    </div>

                    <!-- Input Section -->
                    <div class="mb-6 bg-gray-900/50 p-4 rounded border border-gray-700">
                        <div x-show="splitType === 'people'" x-transition>
                            <label class="block text-gray-400 text-sm font-bold mb-2">Cantidad de Personas</label>
                            <div class="flex items-center gap-4">
                                <button @click="if(people > 1) people--"
                                    class="w-12 h-12 bg-gray-700 hover:bg-gray-600 rounded text-xl font-bold">-</button>
                                <span class="text-3xl font-bold flex-1 text-center" x-text="people"></span>
                                <button @click="people++"
                                    class="w-12 h-12 bg-gray-700 hover:bg-gray-600 rounded text-xl font-bold">+</button>
                            </div>
                            <div class="mt-4 text-center">
                                <span class="text-sm text-gray-400">A pagar por persona:</span>
                                <div class="text-2xl font-bold text-green-400"
                                    x-text="'RD$ ' + parseFloat(amountPerPerson).toLocaleString()"></div>
                            </div>
                        </div>

                        <div x-show="splitType === 'custom'" x-transition>
                            <label class="block text-gray-400 text-sm font-bold mb-2">Monto a Pagar Ahora</label>
                            <input type="number" x-model.number="customAmount" step="0.01"
                                class="w-full bg-gray-800 border border-gray-600 rounded p-3 text-2xl font-bold text-white text-center focus:ring-2 focus:ring-amber-500 outline-none">
                        </div>
                    </div>

                    <!-- Payment Method -->
                    <div class="mb-4">
                        <label class="block text-gray-400 text-xs font-bold mb-2 uppercase">Método de Pago</label>
                        <div class="grid grid-cols-3 gap-2">
                            <label class="cursor-pointer">
                                <input type="radio" name="split_method" value="cash" x-model="method" class="hidden peer">
                                <div
                                    class="bg-gray-700 peer-checked:bg-amber-600 peer-checked:text-white p-2 rounded text-center text-sm transition-colors">
                                    Efectivo</div>
                            </label>
                            <label class="cursor-pointer">
                                <input type="radio" name="split_method" value="card" x-model="method" class="hidden peer">
                                <div
                                    class="bg-gray-700 peer-checked:bg-amber-600 peer-checked:text-white p-2 rounded text-center text-sm transition-colors">
                                    Tarjeta</div>
                            </label>
                            <label class="cursor-pointer">
                                <input type="radio" name="split_method" value="transfer" x-model="method"
                                    class="hidden peer">
                                <div
                                    class="bg-gray-700 peer-checked:bg-amber-600 peer-checked:text-white p-2 rounded text-center text-sm transition-colors">
                                    Transf.</div>
                            </label>
                        </div>
                    </div>

                    <div class="mb-4" x-show="method === 'cash'" x-transition>
                        <label class="block text-gray-400 text-xs font-bold mb-1 uppercase">Monto Recibido</label>
                        <div class="flex gap-2">
                            <input type="number" x-model.number="receivedAmount" step="0.01"
                                class="flex-1 bg-gray-900 border border-gray-700 rounded p-2 text-lg font-bold text-green-400 outline-none">
                            <div class="bg-gray-800 px-3 py-2 rounded border border-gray-700">
                                <span class="text-xs text-gray-500 block">Cambio</span>
                                <span class="font-bold text-white" x-text="change"></span>
                            </div>
                        </div>
                    </div>

                    <?php if(auth()->user()->isAdmin()): ?>
                        <div class="mb-4 bg-amber-900/10 p-3 rounded border border-amber-900/30">
                            <label class="block text-amber-500 text-xs font-bold mb-1 uppercase">Descuento (Admin)</label>
                            <input type="number" x-model.number="discount" step="0.01"
                                class="w-full bg-gray-900 border border-amber-900/50 rounded p-2 text-lg font-bold text-amber-500 outline-none"
                                placeholder="0.00">
                        </div>
                    <?php endif; ?>

                    <div class="flex flex-col gap-3">
                        <button
                            @click="$dispatch('execute-split-amount', { amount: (splitType === 'people' ? amountPerPerson : customAmount), discount: discount, method: method, received: receivedAmount })"
                            :disabled="payAmount <= 0 || payAmount > remaining"
                            class="w-full bg-green-600 hover:bg-green-500 disabled:opacity-50 disabled:cursor-not-allowed text-white font-bold py-4 rounded-xl text-xl shadow-lg transition transform active:scale-95">
                            REGISTRAR PAGO PARCIAL
                        </button>
                    </div>
                </div>
            </div>
        </dialog>
        <SAME>

            <!-- Custom Alert Modal -->
            <dialog id="alertModal"
                class="bg-gray-800 text-white p-6 rounded-lg shadow-2xl border border-gray-700 max-w-sm w-full backdrop:bg-black backdrop:bg-opacity-70">
                <div class="text-center">
                    <div class="text-amber-500 mb-4 flex justify-center">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-12 w-12" fill="none" viewBox="0 0 24 24"
                            stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z" />
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold mb-2" x-text="alertTitle">Aviso</h3>
                    <p class="text-gray-300 mb-6" x-text="alertMsg"></p>
                    <button @click="document.getElementById('alertModal').close()"
                        class="w-full bg-amber-600 hover:bg-amber-500 py-3 rounded-xl font-bold transition transform active:scale-95">
                        ENTENDIDO
                    </button>
                </div>
            </dialog>

            <!-- Custom Confirm Modal -->
            <dialog id="confirmModal"
                class="bg-gray-800 text-white p-6 rounded-lg shadow-2xl border border-gray-700 max-w-sm w-full backdrop:bg-black backdrop:bg-opacity-70">
                <div class="text-center">
                    <div class="text-red-500 mb-4 flex justify-center">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-12 w-12" fill="none" viewBox="0 0 24 24"
                            stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold mb-2" x-text="confirmTitle">Confirmación</h3>
                    <p class="text-gray-300 mb-6" x-text="confirmMsg"></p>
                    <div class="flex gap-3">
                        <button @click="document.getElementById('confirmModal').close()"
                            class="flex-1 bg-gray-700 hover:bg-gray-600 py-3 rounded-xl font-bold transition">
                            CANCELAR
                        </button>
                        <button @click="confirmAction()"
                            class="flex-1 bg-red-600 hover:bg-red-500 py-3 rounded-xl font-bold transition transform active:scale-95">
                            ELIMINAR
                        </button>
                    </div>
                </div>
            </dialog>

            <!-- Rename / Client Name Modal -->
            <dialog id="renameModal"
                class="bg-gray-800 text-white p-0 rounded-lg shadow-2xl backdrop:bg-black backdrop:bg-opacity-70 border border-gray-700">
                <div class="w-[380px]">
                    <div class="bg-gray-700 px-6 py-4 flex justify-between items-center border-b border-gray-600">
                        <h3 class="text-lg font-bold">Nombre del Cliente</h3>
                        <button onclick="document.getElementById('renameModal').close()"
                            class="text-gray-400 hover:text-white">&times;</button>
                    </div>
                    <div class="p-6">
                        <input type="text" x-model="renameInput" x-ref="renameInput"
                            class="w-full px-4 py-2 bg-gray-700 text-white rounded-lg focus:outline-none focus:ring-2 focus:ring-amber-500 border border-gray-600"
                            placeholder="Ej: Mesa de Juan" maxlength="255" @keydown.enter.prevent="saveCliente()">
                    </div>
                    <div class="px-6 py-4 bg-gray-900 border-t border-gray-700 flex justify-end gap-3">
                        <button type="button" onclick="document.getElementById('renameModal').close()"
                            class="px-4 py-2 text-gray-400 hover:text-white transition">Cancelar</button>
                        <button type="button" @click="saveCliente()"
                            class="px-6 py-2 bg-amber-600 hover:bg-amber-700 text-white font-bold rounded-lg transition">Guardar</button>
                    </div>
                </div>
            </dialog>

            <div x-data x-on:execute-split-amount.window="$parent.executeSplitAmount($event.detail)"></div>
    </div>

    <script>
        function posCart(config) {
            return {
                items: config.initialItems,
                total: config.initialTotal,
                clienteLabel: config.initialCliente || '',
                renameInput: '',
                processing: false,
                pendingItems: [],
                activeCategoryId: 'all',
                searchQuery: '',
                searchResults: [],
                searching: false,
                iconMap: <?php echo json_encode($iconMap, 15, 512) ?>,
                csrfToken: document.querySelector('meta[name="csrf-token"]')?.content || '<?php echo e(csrf_token()); ?>',

                alertTitle: 'Aviso',
                alertMsg: '',
                confirmTitle: 'Confirmación',
                confirmMsg: '',
                confirmCallback: null,

                showAlert(title, msg) {
                    this.alertTitle = title;
                    this.alertMsg = msg;
                    document.getElementById('alertModal').showModal();
                },

                showConfirm(title, msg, callback) {
                    this.confirmTitle = title;
                    this.confirmMsg = msg;
                    this.confirmCallback = callback;
                    document.getElementById('confirmModal').showModal();
                },

                confirmAction() {
                    const cb = this.confirmCallback;
                    this.confirmCallback = null;
                    if (cb) cb();
                    document.getElementById('confirmModal').close();
                },

                formatMoney(amount) {
                    return 'RD$ ' + parseFloat(amount).toLocaleString(undefined, { minimumFractionDigits: 2, maximumFractionDigits: 2 });
                },

                openCheckout() {
                    window.dispatchEvent(new CustomEvent('show-checkout', { detail: { total: this.total } }));
                    document.getElementById('checkoutModal').showModal();
                },

                openRenameModal() {
                    this.renameInput = this.clienteLabel;
                    document.getElementById('renameModal').showModal();
                    this.$nextTick(() => {
                        if (this.$refs.renameInput) this.$refs.renameInput.focus();
                    });
                },

                async saveCliente() {
                    try {
                        const response = await fetch(config.updateClienteUrl, {
                            method: 'PATCH',
                            headers: {
                                'Content-Type': 'application/json',
                                'Accept': 'application/json',
                                'X-Requested-With': 'XMLHttpRequest',
                                'X-CSRF-TOKEN': this.csrfToken
                            },
                            body: JSON.stringify({ cliente: this.renameInput })
                        });
                        const data = await response.json();
                        if (data.success) {
                            this.clienteLabel = data.cliente || '';
                            document.getElementById('renameModal').close();
                        } else {
                            this.showAlert('Error', 'No se pudo actualizar el nombre.');
                        }
                    } catch (e) {
                        this.showAlert('Error de Conexión', 'No se pudo guardar el nombre del cliente.');
                    }
                },

                openSplitModal() {
                    window.dispatchEvent(new CustomEvent('open-split', {
                        detail: {
                            total: this.total,
                            paid: <?php echo e($mesa->activeOrder->accumulated_paid ?? 0); ?>

                                        }
                    }));
                    document.getElementById('splitModal').showModal();
                },

                async searchProducts() {
                    if (this.searchQuery.length === 0) {
                        this.searchResults = [];
                        return;
                    }

                    this.searching = true;
                    try {
                        const response = await fetch(`<?php echo e(route('pos.search')); ?>?q=${encodeURIComponent(this.searchQuery)}`, {
                            headers: {
                                'Accept': 'application/json',
                                'X-Requested-With': 'XMLHttpRequest'
                            }
                        });
                        this.searchResults = await response.json();
                    } catch (error) {
                        console.error('Search error:', error);
                    } finally {
                        this.searching = false;
                    }
                },

                async addItem(productId) {
                    if (this.processing) return;
                    this.processing = true;
                    this.pendingItems.push(productId);

                    try {
                        const response = await fetch(config.addItemUrl, {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json',
                                'Accept': 'application/json',
                                'X-Requested-With': 'XMLHttpRequest',
                                'X-CSRF-TOKEN': this.csrfToken
                            },
                            body: JSON.stringify({ product_id: productId, quantity: 1 })
                        });

                        const data = await response.json();
                        if (data.success) {
                            this.items = data.items;
                            this.total = data.total;
                        } else {
                            this.showAlert('Error', data.message || 'No se pudo añadir el producto');
                        }
                    } catch (error) {
                        console.error('Fetch error:', error);
                        this.showAlert('Error de Conexión', 'No pudimos contactar al servidor. Verifica tu internet.');
                    } finally {
                        this.processing = false;
                        this.pendingItems = this.pendingItems.filter(id => id !== productId);
                    }
                },

                async removeItem(detailId) {
                    if (this.processing) return;

                    this.showConfirm('¿Eliminar producto?', '¿Seguro que deseas quitar este artículo de la orden?', () => {
                        this.executeRemoveItem(detailId);
                    });
                },

                async executeRemoveItem(detailId) {
                    this.processing = true;
                    try {
                        const response = await fetch(`${config.removeItemUrlBase}/${detailId}`, {
                            method: 'DELETE',
                            headers: {
                                'Content-Type': 'application/json',
                                'Accept': 'application/json',
                                'X-Requested-With': 'XMLHttpRequest',
                                'X-CSRF-TOKEN': this.csrfToken
                            }
                        });

                        const data = await response.json();
                        if (data.success) {
                            this.items = data.items;
                            this.total = data.total;
                        } else {
                            this.showAlert('Error', data.message || 'No se pudo eliminar el producto');
                        }
                    } catch (error) {
                        console.error('Fetch error:', error);
                        this.showAlert('Error de Conexión', 'Problema al eliminar el producto.');
                    } finally {
                        this.processing = false;
                    }
                },

                async executeSplitAmount(payload) {
                    if (this.processing) return;
                    this.processing = true;

                    try {
                        const response = await fetch('<?php echo e(route('order.split-amount', $mesa->activeOrder)); ?>', {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json',
                                'Accept': 'application/json',
                                'X-Requested-With': 'XMLHttpRequest',
                                'X-CSRF-TOKEN': this.csrfToken
                            },
                            body: JSON.stringify({
                                amount: payload.amount,
                                discount: payload.discount,
                                payment_method: payload.method,
                                amount_paid: payload.received
                            })
                        });

                        const data = await response.json();
                        if (data.success) {
                            // Trigger printing if available
                            /* 
                            if (data.print_order) {
                                // Logic for silent print or browser print
                            }
                            */

                            if (data.redirect) {
                                window.location.href = data.redirect;
                            } else {
                                // Refresh to show updated paid amount
                                window.location.reload();
                            }
                        } else {
                            this.showAlert('Error', data.message || 'No se pudo procesar el pago parcial');
                        }
                    } catch (error) {
                        console.error('Split error:', error);
                        this.showAlert('Error de Conexión', 'No se pudo procesar el pago parcial.');
                    } finally {
                        this.processing = false;
                        document.getElementById('splitModal').close();
                    }
                }
            }
        }
    </script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\SukhaCigarBar\resources\views/pos/table-order.blade.php ENDPATH**/ ?>