

<?php $__env->startSection('content'); ?>
    <div class="max-w-7xl mx-auto py-6 sm:px-6 lg:px-8">
        <!-- Screen View Container -->
        <div class="bg-gray-800 rounded-lg shadow-xl p-6 border border-gray-700 no-print">
            <div class="flex justify-between items-center mb-6">
                <div>
                    <h1 class="text-2xl font-bold text-white">Reporte Detallado de Ventas</h1>
                    <p class="text-gray-400">Rango: <?php echo e(\Carbon\Carbon::parse($startDate)->format('d/m/Y')); ?> -
                        <?php echo e(\Carbon\Carbon::parse($endDate)->format('d/m/Y')); ?></p>
                </div>
                <button onclick="window.print()"
                    class="bg-amber-600 hover:bg-amber-700 text-white px-4 py-2 rounded-lg font-bold transition">
                    <i class="bi bi-printer mr-2"></i> Imprimir 80mm
                </button>
            </div>

            <!-- Filters (Hidden when printing) -->
            <div class="mb-8 p-4 bg-gray-900 rounded-lg">
                <form action="<?php echo e(route('reports.product_sales')); ?>" method="GET" class="flex flex-wrap items-end gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-400 mb-1">Fecha Inicio</label>
                        <input type="date" name="start_date" value="<?php echo e($startDate); ?>"
                            class="bg-gray-800 border-gray-700 text-white rounded-md focus:ring-amber-500 focus:border-amber-500">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-400 mb-1">Fecha Fin</label>
                        <input type="date" name="end_date" value="<?php echo e($endDate); ?>"
                            class="bg-gray-800 border-gray-700 text-white rounded-md focus:ring-amber-500 focus:border-amber-500">
                    </div>
                    <button type="submit" class="bg-gray-700 hover:bg-gray-600 text-white px-4 py-2 rounded-md transition">
                        Filtrar
                    </button>
                </form>
            </div>

            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-700">
                    <thead class="bg-gray-900">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-semibold text-gray-400 uppercase">Producto</th>
                            <th class="px-6 py-3 text-center text-xs font-semibold text-gray-400 uppercase tracking-wider">
                                Cant.</th>
                            <th class="px-6 py-3 text-right text-xs font-semibold text-gray-400 uppercase tracking-wider">
                                Total</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-700">
                        <?php $__empty_1 = true; $__currentLoopData = $productSales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="hover:bg-gray-750 transition-colors">
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-white"><?php echo e($sale->product_name); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-center text-gray-300">
                                    <?php echo e(number_format($sale->total_quantity, 0)); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-right font-bold text-amber-500">RD$
                                    <?php echo e(number_format($sale->total_revenue, 2)); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="3" class="px-6 py-10 text-center text-gray-500">No hay ventas.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Print Only 80mm View -->
        <div class="print-only">
            <center>
                <h2 style="font-size: 1.2rem; margin: 0;">SUKHA CIGAR BAR & LOUNGE</h2>
                <p style="font-size: 0.8rem; margin: 2px 0;">Av. Principal #123, Plaza Central</p>
                <p style="font-size: 0.8rem; margin: 2px 0;">Tel: (809) 555-0199 | RNC: 123-45678-9</p>
                <h3
                    style="font-size: 1rem; margin: 10px 0; border-top: 1px dashed black; border-bottom: 1px dashed black; padding: 5px 0;">
                    REPORTE DE VENTAS
                </h3>
            </center>

            <table style="width: 100%; font-size: 0.8rem; border-collapse: collapse; margin-bottom: 10px;">
                <tr>
                    <td><b>Desde:</b> <?php echo e(\Carbon\Carbon::parse($startDate)->format('d/m/Y')); ?></td>
                </tr>
                <tr>
                    <td><b>Hasta:</b> <?php echo e(\Carbon\Carbon::parse($endDate)->format('d/m/Y')); ?></td>
                </tr>
                <tr>
                    <td><b>Fecha Impresión:</b> <?php echo e(now()->format('d/m/Y H:i')); ?></td>
                </tr>
                <tr>
                    <td><b>Generado por:</b> <?php echo e(auth()->user()->name); ?></td>
                </tr>
            </table>

            <table style="width: 100%; font-size: 0.75rem; border-collapse: collapse;">
                <thead style="border-bottom: 1px solid black;">
                    <tr>
                        <th style="text-align: left; padding: 4px 0;">Cant</th>
                        <th style="text-align: left; padding: 4px 0;">Descripción</th>
                        <th style="text-align: right; padding: 4px 0;">Total</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $productSales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td style="padding: 4px 0;"><?php echo e(number_format($sale->total_quantity, 0)); ?></td>
                            <td style="padding: 4px 0;"><?php echo e($sale->product_name); ?></td>
                            <td style="padding: 4px 0; text-align: right;"><?php echo e(number_format($sale->total_revenue, 0)); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>

            <div style="border-top: 1px solid black; margin-top: 10px; padding-top: 5px; text-align: right;">
                <p style="font-size: 1.1rem; font-weight: bold; margin: 0;">TOTAL: RD$ <?php echo e(number_format($grandTotal, 2)); ?>

                </p>
            </div>

            <center style="margin-top: 20px; font-size: 0.7rem; color: #666;">
                --- Fin del Reporte ---
            </center>
        </div>
    </div>

    <style>
        .print-only {
            display: none;
        }

        @media print {
            .no-print, nav, footer {
                display: none !important;
            }

            .print-only {
                display: block !important;
                width: 100%;
                max-width: 72mm;
                margin: 0;
                padding: 0;
                color: black !important;
                font-family: 'Courier New', Courier, monospace;
            }

            @page {
                size: 80mm auto;
                margin: 0;
            }

            body {
                background: white !important;
                margin: 0;
                padding: 0;
            }

            main {
                padding: 0 !important;
                margin: 0 !important;
                max-width: none !important;
            }

            .max-w-7xl {
                max-width: none !important;
                padding: 0 !important;
                margin: 0 !important;
            }
        }
    </style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\SukhaCigarBar\resources\views/admin/reports/product_sales.blade.php ENDPATH**/ ?>