

<?php $__env->startSection('content'); ?>
    <div class="max-w-4xl mx-auto py-12 px-6">
        <div class="bg-gray-800 shadow-xl rounded-lg border border-gray-700 overflow-hidden">

            <!-- Header -->
            <div class="bg-gray-900 p-6 border-b border-gray-700 flex justify-between items-center">
                <div>
                    <h1 class="text-2xl font-bold text-white">Estado de Caja: <span
                            class="text-amber-500"><?php echo e($caja->name); ?></span></h1>
                    <p class="text-sm text-gray-400">Sesión iniciada: <?php echo e($apertura->fecha_apertura->format('d/m/Y h:i A')); ?>

                    </p>
                </div>
                <span
                    class="bg-green-900 text-green-300 px-3 py-1 rounded-full text-xs font-bold uppercase tracking-wide border border-green-700">
                    Abierta
                </span>
            </div>

            <div class="p-6">
                <!-- Stats Grid -->
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
                    <!-- Initial -->
                    <div class="bg-gray-700 p-4 rounded-lg">
                        <span class="text-gray-400 text-xs uppercase tracking-wider">Monto Inicial</span>
                        <div class="text-2xl font-bold text-white mt-1">$<?php echo e(number_format($apertura->monto_inicial, 2)); ?>

                        </div>
                    </div>

                    <!-- Sales (Cash) -->
                    <?php
                        $cashSales = $apertura->sales->where('payment_method', 'cash')->where('is_internal', false)->sum('total');
                        $otherSales = $apertura->sales->where('payment_method', '!=', 'cash')->where('is_internal', false)->sum('total');
                        $internalUse = $apertura->sales->where('is_internal', true)->sum('total');
                    ?>
                    <div class="bg-gray-700 p-4 rounded-lg">
                        <span class="text-gray-400 text-xs uppercase tracking-wider">Ventas Efectivo</span>
                        <div class="text-2xl font-bold text-green-400 mt-1">+$<?php echo e(number_format($cashSales, 2)); ?></div>
                    </div>

                    <!-- Expected Cash -->
                    <div class="bg-gray-700 p-4 rounded-lg border border-amber-500/30">
                        <span class="text-amber-500 text-xs uppercase tracking-wider font-bold">Efectivo Esperado</span>
                        <div class="text-2xl font-bold text-white mt-1">
                            $<?php echo e(number_format($apertura->monto_inicial + $cashSales, 2)); ?></div>
                    </div>
                </div>

                <!-- Detailed Stats -->
                <div class="space-y-4 mb-8 bg-gray-900/40 p-6 rounded-xl border border-gray-700">
                    <div class="flex justify-between border-b border-gray-700 pb-2">
                        <span class="text-gray-400">Ventas Otros Métodos (Tarjeta/Transf.)</span>
                        <span class="text-white font-bold">$<?php echo e(number_format($otherSales, 2)); ?></span>
                    </div>
                    <div class="flex justify-between border-b border-gray-700 pb-2">
                        <span class="text-amber-500/70 font-medium">Consumo Interno (No afecta caja)</span>
                        <span class="text-amber-500 font-bold">$<?php echo e(number_format($internalUse, 2)); ?></span>
                    </div>
                    <!-- Add Expenses here if implemented -->
                </div>

                <!-- Actions -->
                <div class="flex flex-col md:flex-row gap-4">
                    <a href="<?php echo e(route('pos.index')); ?>"
                        class="flex-1 bg-blue-600 hover:bg-blue-500 text-white font-bold py-3 px-4 rounded text-center transition">
                        Ir al POS
                    </a>
                    <a href="<?php echo e(route('caja.close')); ?>"
                        class="flex-1 bg-red-600 hover:bg-red-500 text-white font-bold py-3 px-4 rounded text-center transition">
                        Realizar Arqueo y Cerrar
                    </a>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\SukhaCigarBar\resources\views/caja/status.blade.php ENDPATH**/ ?>