

<?php $__env->startSection('content'); ?>
    <div class="max-w-7xl mx-auto py-6 sm:px-6 lg:px-8">
        <h1 class="text-3xl font-bold text-gray-100 mb-6">Reporte de Inventario</h1>

        <!-- Summary -->
        <div class="mb-8 bg-gray-800 rounded-lg shadow p-6">
            <h3 class="text-gray-400 text-sm font-medium">Valor Total del Inventario</h3>
            <p class="text-3xl font-bold text-green-400 mt-2">$<?php echo e(number_format($stockValue, 2)); ?></p>
        </div>

        <!-- Low Stock Alert -->
        <div class="mb-8">
            <h2 class="text-xl font-bold text-red-400 mb-4">Productos con Stock Bajo</h2>
            <div class="bg-gray-800 shadow rounded-lg overflow-hidden">
                <table class="min-w-full divide-y divide-gray-700">
                    <thead class="bg-gray-700">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">
                                Producto</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Stock
                                Actual</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Min.
                                Stock</th>
                        </tr>
                    </thead>
                    <tbody class="bg-gray-800 divide-y divide-gray-700 text-gray-200">
                        <?php $__empty_1 = true; $__currentLoopData = $lowStockProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td class="px-6 py-4 whitespace-nowrap"><?php echo e($product->name); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap text-red-400 font-bold"><?php echo e($product->stock); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap text-gray-400"><?php echo e($product->min_stock); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="3" class="px-6 py-4 text-center text-gray-500">No hay productos con stock bajo.
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Recent Movements -->
        <div>
            <h2 class="text-xl font-bold text-gray-100 mb-4">Movimientos Recientes</h2>
            <div class="bg-gray-800 shadow rounded-lg overflow-hidden">
                <table class="min-w-full divide-y divide-gray-700">
                    <thead class="bg-gray-700">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Fecha
                            </th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">
                                Producto</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Tipo
                            </th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">
                                Cantidad</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">
                                Usuario</th>
                        </tr>
                    </thead>
                    <tbody class="bg-gray-800 divide-y divide-gray-700 text-gray-200">
                        <?php $__currentLoopData = $movements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $movement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td class="px-6 py-4 whitespace-nowrap"><?php echo e($movement->created_at->format('Y-m-d H:i')); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap"><?php echo e($movement->product->name); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span
                                        class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full <?php echo e($movement->type === 'entrada' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800'); ?>">
                                        <?php echo e(ucfirst($movement->type)); ?>

                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap"><?php echo e($movement->quantity); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap"><?php echo e($movement->user->name); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\SukhaCigarBar\resources\views/admin/reports/inventory.blade.php ENDPATH**/ ?>