

<?php $__env->startSection('content'); ?>
    <div class="max-w-7xl mx-auto py-6 sm:px-6 lg:px-8">
        <h1 class="text-3xl font-bold text-gray-100 mb-6">Dashboard Administrativo</h1>

        <!-- Stats Grid -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
            <!-- Ventas del Día -->
            <div class="bg-gray-800 overflow-hidden shadow rounded-lg border border-gray-700">
                <div class="p-5">
                    <div class="flex items-center">
                        <div class="flex-shrink-0 bg-amber-600 rounded-md p-3">
                            <!-- Icono Ventas -->
                            <svg class="h-6 w-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z">
                                </path>
                            </svg>
                        </div>
                        <div class="ml-5 w-0 flex-1">
                            <dl>
                                <dt class="text-sm font-medium text-gray-400 truncate">Ventas del Día</dt>
                                <dd class="text-2xl font-semibold text-gray-100">RD$ <?php echo e(number_format($ventasDia, 2)); ?></dd>
                            </dl>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Caja Actual -->
            <div class="bg-gray-800 overflow-hidden shadow rounded-lg border border-gray-700">
                <div class="p-5">
                    <div class="flex items-center">
                        <div
                            class="flex-shrink-0 <?php if($cajaStatus == 'Abierta'): ?> bg-green-600 <?php else: ?> bg-gray-600 <?php endif; ?> rounded-md p-3">
                            <!-- Icono Caja -->
                            <svg class="h-6 w-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z">
                                </path>
                            </svg>
                        </div>
                        <div class="ml-5 w-0 flex-1">
                            <dl>
                                <dt class="text-sm font-medium text-gray-400 truncate">Caja Actual</dt>
                                <dd
                                    class="text-2xl font-semibold <?php if($cajaStatus == 'Abierta'): ?> text-green-400 <?php else: ?> text-gray-400 <?php endif; ?>">
                                    <?php echo e($cajaStatus); ?>

                                </dd>
                            </dl>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Productos Bajos -->
            <div class="bg-gray-800 overflow-hidden shadow rounded-lg border border-gray-700">
                <div class="p-5">
                    <div class="flex items-center">
                        <div class="flex-shrink-0 <?php if($stockAlerts > 0): ?> bg-red-600 <?php else: ?> bg-gray-600 <?php endif; ?> rounded-md p-3">
                            <!-- Icono Alerta -->
                            <svg class="h-6 w-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z">
                                </path>
                            </svg>
                        </div>
                        <div class="ml-5 w-0 flex-1">
                            <dl>
                                <dt class="text-sm font-medium text-gray-400 truncate">Alertas Stock</dt>
                                <dd
                                    class="text-2xl font-semibold <?php if($stockAlerts > 0): ?> text-red-500 <?php else: ?> text-gray-100 <?php endif; ?>">
                                    <?php echo e($stockAlerts); ?>

                                </dd>
                            </dl>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Recent Activity -->
        <div class="bg-gray-800 shadow rounded-lg border border-gray-700 p-6">
            <h3 class="text-lg leading-6 font-medium text-gray-100 mb-4">Actividad Reciente</h3>
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-700">
                    <thead>
                        <tr>
                            <th class="px-4 py-2 text-left text-xs font-medium text-gray-400 uppercase">Usuario</th>
                            <th class="px-4 py-2 text-left text-xs font-medium text-gray-400 uppercase">Acción</th>
                            <th class="px-4 py-2 text-left text-xs font-medium text-gray-400 uppercase">Fecha</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-700">
                        <?php $__empty_1 = true; $__currentLoopData = $actividadReciente; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td class="px-4 py-3 text-sm text-gray-200"><?php echo e($log->user->name); ?></td>
                                <td class="px-4 py-3 text-sm text-gray-300">
                                    <span class="font-bold text-amber-500"><?php echo e($log->action); ?>:</span>
                                    <?php echo e($log->description); ?>

                                </td>
                                <td class="px-4 py-3 text-sm text-gray-400"><?php echo e($log->created_at->diffForHumans()); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="3" class="px-4 py-6 text-center text-gray-500">No hay actividad registrada aún.
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\SukhaCigarBar\resources\views/admin/dashboard.blade.php ENDPATH**/ ?>