<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>{{ $config->welcome_message ?: 'Sukha Cigar Bar - Menú' }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;600;700&family=Playfair+Display:ital,wght@0,700;1,700&display=swap');

        body {
            font-family: 'Outfit', sans-serif;
            background-color: #0c0a09;
            color: #e7e5e4;
            -webkit-tap-highlight-color: transparent;
        }

        .font-serif {
            font-family: 'Playfair Display', serif;
        }

        .glass {
            background: rgba(28, 25, 23, 0.7);
            backdrop-filter: blur(12px);
            -webkit-backdrop-filter: blur(12px);
            border: 1px solid rgba(255, 255, 255, 0.05);
        }

        .category-tab.active {
            color: white;
            border-bottom: 2px solid
                {{ $config->primary_color ?: '#b45309' }}
            ;
        }

        .product-card {
            transition: transform 0.2s ease, opacity 0.3s ease;
        }

        .product-card:active {
            transform: scale(0.98);
        }

        @keyframes shimmer {
            0% {
                transform: translateX(-100%) rotate(45deg);
            }

            100% {
                transform: translateX(200%) rotate(45deg);
            }
        }

        @keyframes flame-glow {

            0%,
            100% {
                box-shadow: 0 0 20px rgba(99, 102, 241, 0.2), 0 0 40px rgba(99, 102, 241, 0.1);
            }

            50% {
                box-shadow: 0 0 40px rgba(99, 102, 241, 0.4), 0 0 80px rgba(99, 102, 241, 0.2);
            }
        }

        .flame-effect {
            position: relative;
            overflow: hidden;
            animation: flame-glow 3s infinite ease-in-out;
        }

        .flame-effect::after {
            content: '';
            position: absolute;
            top: -100%;
            left: -100%;
            width: 50%;
            height: 300%;
            background: linear-gradient(to right,
                    transparent,
                    rgba(255, 255, 255, 0.1),
                    transparent);
            transform: rotate(45deg);
            animation: shimmer 4s infinite;
        }

        ::-webkit-scrollbar {
            width: 0;
            height: 0;
        }
    </style>
</head>

<body x-data="{ 
    activeCategory: 'all', 
    search: '', 
    filteredProductsCount: 0,
    categories: {{ $categories->toJson() }},
    
    get filteredCount() {
        let count = 0;
        this.categories.forEach(cat => {
            cat.products.forEach(prod => {
                if ((this.activeCategory === 'all' || cat.id == this.activeCategory) && 
                    (this.search === '' || prod.name.toLowerCase().includes(this.search.toLowerCase()))) {
                    count++;
                }
            });
        });
        return count;
    }
}">

    <!-- Header / Banner -->
    <header class="relative h-64 overflow-hidden">
        <div class="absolute inset-0 bg-gradient-to-t from-[#0c0a09] via-transparent to-transparent z-10"></div>
        <img src="{{ $config->banner_url ?: 'https://images.unsplash.com/photo-1510440330103-68f7601cf906?q=80&w=2070&auto=format&fit=crop' }}"
            class="absolute inset-0 w-full h-full object-cover" alt="Banner">

        <div class="absolute bottom-6 left-6 right-6 z-20">
            <h1 class="text-3xl font-bold font-serif text-white tracking-tight">
                {{ $config->welcome_message ?: 'Sukha' }}
            </h1>
            <p class="text-amber-500 font-semibold text-sm uppercase tracking-widest">
                {{ $config->welcome_subtitle ?: 'Cigar Bar & Lounge' }}
            </p>
        </div>
    </header>

    <!-- Search Bar (Sticky) -->
    <div class="sticky top-0 z-30 px-4 py-3 glass border-b border-white/5">
        <div class="relative">
            <i class="bi bi-search absolute left-4 top-1/2 -translate-y-1/2 text-gray-400"></i>
            <input type="text" x-model="search" placeholder="Búscar puros, tragos..."
                class="w-full bg-stone-900/80 border border-white/10 rounded-2xl py-3 pl-12 pr-4 text-sm focus:outline-none focus:ring-1 focus:ring-amber-500/50 transition-all">
        </div>
    </div>

    <!-- Category Tabs -->
    <nav class="flex overflow-x-auto px-4 py-4 gap-4 sticky top-[68px] z-20 bg-[#0c0a09]/95 backdrop-blur-md">
        <button @click="activeCategory = 'all'"
            :class="activeCategory === 'all' ? 'bg-amber-600 text-white shadow-lg shadow-amber-900/20' : 'bg-stone-900 text-stone-400'"
            class="whitespace-nowrap px-6 py-2 rounded-full text-sm font-bold transition-all duration-300">
            Todo
        </button>
        @foreach($categories as $category)
            <button @click="activeCategory = {{ $category->id }}"
                :class="activeCategory == {{ $category->id }} ? 'bg-amber-600 text-white shadow-lg shadow-amber-900/20' : 'bg-stone-900 text-stone-400'"
                class="whitespace-nowrap px-6 py-2 rounded-full text-sm font-bold transition-all duration-300">
                {{ $category->name }}
            </button>
        @endforeach
    </nav>

    <!-- Featured Offers (Combos) -->
    @if($combos->count() > 0)
        <section class="px-4 py-8 overflow-hidden" x-show="activeCategory === 'all' && search === ''" x-transition>
            <div class="flex items-center justify-between mb-4">
                <h2 class="text-xl font-bold font-serif text-white flex items-center gap-2">
                    <i class="bi bi-stars text-amber-500"></i> Ofertas Especiales
                </h2>
                <span class="text-[10px] text-stone-500 uppercase tracking-widest font-bold">Exclusivo Sukha</span>
            </div>

            <div class="flex overflow-x-auto gap-4 pb-4 -mx-4 px-4 snap-x">
                @foreach($combos as $combo)
                    <div
                        class="min-w-[280px] bg-gradient-to-br from-indigo-900/60 via-stone-900/40 to-indigo-900/60 rounded-[32px] p-5 border border-indigo-500/30 snap-center relative overflow-hidden group flame-effect transition-all duration-500 hover:scale-[1.02]">
                        <div
                            class="absolute -right-4 -top-4 w-24 h-24 bg-indigo-500/20 rounded-full blur-2xl group-hover:bg-indigo-500/30 transition-all">
                        </div>

                        <div class="flex justify-between items-start mb-4 relative z-10">
                            <div
                                class="w-16 h-16 rounded-2xl overflow-hidden bg-stone-900 shadow-xl border border-white/5 relative">
                                <img src="{{ $combo->image_url ? (str_starts_with($combo->image_url, 'http') ? $combo->image_url : asset($combo->image_url)) : 'https://images.unsplash.com/photo-1527661591475-527312dd65f5?q=80&w=500&auto=format&fit=crop' }}"
                                    class="w-full h-full object-cover">
                                <div class="absolute inset-0 bg-gradient-to-t from-black/40 to-transparent"></div>
                            </div>
                            <div class="flex flex-col items-end gap-2">
                                <span
                                    class="bg-indigo-600 text-white text-[10px] px-3 py-1 rounded-full font-bold uppercase tracking-tighter shadow-lg shadow-indigo-500/20">Recommended</span>
                                <div class="flex items-center gap-1 text-amber-500 text-[10px] font-bold animate-pulse">
                                    <i class="bi bi-fire"></i> HOT
                                </div>
                            </div>
                        </div>

                        <h3 class="font-bold text-white text-lg leading-tight mb-2">{{ $combo->name }}</h3>
                        <p class="text-xs text-stone-400 line-clamp-2 mb-4">
                            {{ $combo->description ?: 'Disfruta de nuestra selección premium preparada especialmente para ti.' }}
                        </p>

                        <div class="space-y-1.5 mb-4">
                            @foreach($combo->packageItems as $item)
                                <div class="flex items-center gap-2 text-[10px] text-stone-300">
                                    <i class="bi bi-check2 text-indigo-400"></i>
                                    <span>{{ $item->quantity }}x {{ $item->product->name }}</span>
                                </div>
                            @endforeach
                        </div>

                        <div class="flex items-center justify-between mt-auto">
                            <div class="flex flex-col">
                                <span class="text-[10px] text-stone-500 line-through">RD$
                                    {{ number_format($combo->sale_price * 1.2, 0) }}</span>
                                <span class="text-white font-bold text-2xl tracking-tighter">RD$
                                    {{ number_format($combo->sale_price, 0) }}</span>
                            </div>
                            <div
                                class="w-10 h-10 bg-white/5 rounded-full flex items-center justify-center border border-white/10">
                                <i class="bi bi-arrow-right text-indigo-400"></i>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </section>
    @endif

    <!-- Product Grid -->
    <main class="px-4 pb-20">
        <template x-if="filteredCount === 0">
            <div class="py-20 text-center">
                <i class="bi bi-emoji-frown text-4xl text-stone-700 mb-4 block"></i>
                <p class="text-stone-500">No encontramos lo que buscas...</p>
            </div>
        </template>

        <div class="space-y-8">
            @foreach($categories as $category)
                <div x-show="activeCategory === 'all' || activeCategory == {{ $category->id }}"
                    x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 translate-y-4"
                    x-transition:enter-end="opacity-100 translate-y-0" class="category-section">

                    <h2 class="text-lg font-bold mb-4 flex items-center gap-2">
                        <span class="w-1 h-6 bg-amber-600 rounded-full"></span>
                        {{ $category->name }}
                    </h2>

                    <div class="grid grid-cols-1 gap-4">
                        @foreach($category->products as $product)
                            <div x-show="search === '' || '{{ strtolower($product->name) }}'.includes(search.toLowerCase())"
                                class="product-card glass p-3 rounded-2xl flex gap-4 items-center">

                                <div class="w-20 h-20 rounded-xl overflow-hidden bg-stone-900 flex-shrink-0">
                                    <img src="{{ $product->image_url ? (str_starts_with($product->image_url, 'http') ? $product->image_url : asset($product->image_url)) : 'https://images.unsplash.com/photo-1527661591475-527312dd65f5?q=80&w=500&auto=format&fit=crop' }}"
                                        class="w-full h-full object-cover" alt="{{ $product->name }}">
                                </div>

                                <div class="flex-grow">
                                    <div class="flex items-center gap-2">
                                        <h3 class="font-bold text-white text-base leading-tight">{{ $product->name }}</h3>
                                        @if($product->type === 'bundle')
                                            <span
                                                class="bg-indigo-500/10 text-indigo-400 text-[10px] px-1.5 py-0.5 rounded border border-indigo-500/20 font-bold uppercase tracking-wider">Combo</span>
                                        @endif
                                    </div>
                                    <p class="text-xs text-stone-400 mt-1 line-clamp-2">
                                        {{ $product->description ?: 'Producto premium de Sukha Cigar Bar.' }}
                                    </p>

                                    @if($product->type === 'bundle' && $product->packageItems->count() > 0)
                                        <div class="mt-2 flex flex-wrap gap-1">
                                            @foreach($product->packageItems as $item)
                                                <span
                                                    class="text-[9px] bg-stone-800 text-stone-500 border border-white/5 px-1.5 py-0.5 rounded">
                                                    {{ $item->quantity }}x {{ $item->product->name }}
                                                </span>
                                            @endforeach
                                        </div>
                                    @endif

                                    <div class="mt-3 flex justify-between items-center">
                                        <span class="text-amber-500 font-bold text-lg">
                                            @if($config->show_prices)
                                                RD$ {{ number_format($product->sale_price, 0) }}
                                            @endif
                                        </span>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            @endforeach
        </div>
    </main>

    <!-- Footer -->
    <footer class="py-10 text-center border-t border-white/5 opacity-50">
        <p class="text-xs tracking-widest font-serif italic">SUKHA CIGAR BAR & LOUNGE</p>
        <p class="text-[10px] mt-2">&copy; {{ date('Y') }} Todos los derechos reservados</p>
    </footer>


</body>

</html>