@extends('layouts.app')

@section('content')
    <div class="max-w-7xl mx-auto py-12 px-4 sm:px-6 lg:px-8">
        <div class="max-w-3xl mx-auto bg-gray-800 rounded-lg shadow-xl overflow-hidden border border-gray-700">
            <div class="px-6 py-4 bg-gray-900 border-b border-gray-700">
                <h3 class="text-xl font-bold text-white">Nuevo Producto</h3>
            </div>

            <form action="{{ route('products.store') }}" method="POST" enctype="multipart/form-data" class="p-6">
                @csrf

                <div class="grid grid-cols-1 gap-y-6 gap-x-4 sm:grid-cols-6" x-data="{ 
                                type: 'simple',
                                items: [],
                                addProduct() {
                                    this.items.push({ product_id: '', quantity: 1 });
                                },
                                removeProduct(index) {
                                    this.items.splice(index, 1);
                                }
                            }">
                    <!-- Tipo -->
                    <div class="sm:col-span-2">
                        <label for="type" class="block text-sm font-medium text-gray-300">Tipo de Producto</label>
                        <select id="type" name="type" x-model="type" required
                            class="mt-1 block w-full py-2 px-3 border border-gray-600 bg-gray-700 text-white rounded-md shadow-sm focus:outline-none focus:ring-amber-500 focus:border-amber-500 sm:text-sm">
                            <option value="simple">Simple</option>
                            <option value="bundle">Paquete / Combo</option>
                        </select>
                    </div>

                    <!-- Nombre -->
                    <div class="sm:col-span-4">
                        <label for="name" class="block text-sm font-medium text-gray-300">Nombre del Producto</label>
                        <input type="text" name="name" id="name" required
                            class="mt-1 focus:ring-amber-500 focus:border-amber-500 block w-full shadow-sm sm:text-sm border-gray-600 bg-gray-700 text-white rounded-md">
                    </div>

                    <!-- Categoría -->
                    <div class="sm:col-span-3">
                        <label for="category_id" class="block text-sm font-medium text-gray-300">Categoría</label>
                        <select id="category_id" name="category_id"
                            class="mt-1 block w-full py-2 px-3 border border-gray-600 bg-gray-700 text-white rounded-md shadow-sm focus:outline-none focus:ring-amber-500 focus:border-amber-500 sm:text-sm">
                            @foreach($categories as $category)
                                <option value="{{ $category->id }}">{{ $category->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <!-- Barcode -->
                    <div class="sm:col-span-3">
                        <label for="barcode" class="block text-sm font-medium text-gray-300">Código de Barras
                            (Opcional)</label>
                        <input type="text" name="barcode" id="barcode"
                            class="mt-1 focus:ring-amber-500 focus:border-amber-500 block w-full shadow-sm sm:text-sm border-gray-600 bg-gray-700 text-white rounded-md">
                    </div>

                    <!-- Componentes (Solo para combos) -->
                    <div class="sm:col-span-6 border-t border-gray-700 pt-4" x-show="type === 'bundle'" x-transition>
                        <div class="flex items-center justify-between mb-2">
                            <h4 class="text-md font-semibold text-amber-500">Componentes del Paquete</h4>
                            <button type="button" @click="addProduct()"
                                class="text-xs bg-amber-500 text-gray-900 px-2 py-1 rounded hover:bg-amber-400">
                                + Agregar Producto
                            </button>
                        </div>

                        <div class="space-y-2">
                            <template x-for="(item, index) in items" :key="index">
                                <div class="flex gap-2">
                                    <select :name="'items['+index+'][product_id]'" required
                                        class="block w-full border-gray-600 bg-gray-700 text-white rounded-md shadow-sm focus:ring-amber-500 focus:border-amber-500 sm:text-sm">
                                        <option value="">Seleccionar Producto...</option>
                                        @foreach($allProducts as $p)
                                            <option value="{{ $p->id }}">{{ $p->name }} (Stock: {{ $p->stock }})</option>
                                        @endforeach
                                    </select>
                                    <input type="number" :name="'items['+index+'][quantity]'" min="1" placeholder="Cant"
                                        required
                                        class="w-20 border-gray-600 bg-gray-700 text-white rounded-md shadow-sm focus:ring-amber-500 focus:border-amber-500 sm:text-sm">
                                    <button type="button" @click="removeProduct(index)"
                                        class="text-red-500 hover:text-red-400">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </div>
                            </template>
                        </div>
                    </div>

                    <!-- Precios -->
                    <div class="sm:col-span-2">
                        <label for="purchase_price" class="block text-sm font-medium text-gray-300">Precio Compra</label>
                        <input type="number" step="0.01" name="purchase_price" id="purchase_price" required
                            class="mt-1 focus:ring-amber-500 focus:border-amber-500 block w-full shadow-sm sm:text-sm border-gray-600 bg-gray-700 text-white rounded-md">
                    </div>

                    <div class="sm:col-span-2">
                        <label for="sale_price" class="block text-sm font-medium text-gray-300">Precio Venta</label>
                        <input type="number" step="0.01" name="sale_price" id="sale_price" required
                            class="mt-1 focus:ring-amber-500 focus:border-amber-500 block w-full shadow-sm sm:text-sm border-gray-600 bg-gray-700 text-white rounded-md">
                    </div>

                    <div class="sm:col-span-2">
                        <label for="min_stock" class="block text-sm font-medium text-gray-300">Stock Mínimo</label>
                        <input type="number" name="min_stock" id="min_stock" value="5" required
                            class="mt-1 focus:ring-amber-500 focus:border-amber-500 block w-full shadow-sm sm:text-sm border-gray-600 bg-gray-700 text-white rounded-md">
                    </div>

                    <!-- Imagen -->
                    <div class="sm:col-span-6">
                        <label for="image" class="block text-sm font-medium text-gray-300">Imagen del Producto (Para el Menú
                            Digital)</label>
                        <input type="file" name="image" id="image" accept="image/*"
                            class="mt-1 focus:ring-amber-500 focus:border-amber-500 block w-full shadow-sm sm:text-sm border-gray-600 bg-gray-700 text-white rounded-md p-2">
                        <p class="mt-1 text-xs text-gray-500">Selecciona una imagen de tu computadora para mostrarla en el
                            menú QR.</p>
                    </div>
                </div>

                <div class="mt-6 flex items-center justify-end">
                    <a href="{{ route('products.index') }}" class="text-gray-400 hover:text-white text-sm mr-4">Cancelar</a>
                    <button type="submit"
                        class="inline-flex items-center px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-gray-900 bg-amber-500 hover:bg-amber-400 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-amber-500">
                        Guardar Producto
                    </button>
                </div>
            </form>
        </div>
    </div>
@endsection