@if ($mesa->status === 'libre' && !$mesa->activeOrder)
    <button type="button" @click="openMesa({{ $mesa }})"
        class="w-full h-32 rounded-xl shadow-lg flex flex-col items-center justify-center transition transform hover:scale-105 bg-green-600 hover:bg-green-500">
        <span class="text-2xl font-bold text-white">{{ $mesa->name }}</span>
        @if($mesa->is_internal)
            <span
                class="text-[9px] bg-purple-900/50 text-purple-200 px-1.5 py-0.5 rounded border border-purple-500/30 uppercase font-bold mt-1">Uso
                Interno</span>
        @endif
        @if($mesa->capacity) <span class="text-[10px] text-green-200 uppercase tracking-tighter mt-1">Cap:
        {{ $mesa->capacity }}</span> @endif
        <span class="mt-2 text-xs bg-white bg-opacity-20 px-2 py-1 rounded font-bold">Abrir</span>
    </button>
@else
    <a href="{{ route('pos.table.show', $mesa) }}"
        class="w-full h-32 rounded-xl shadow-lg flex flex-col items-center justify-center transition transform hover:scale-105
                                {{ $mesa->status === 'libre' ? 'bg-green-600 hover:bg-green-500' : 'bg-orange-600 hover:bg-orange-500' }}">

        <span class="text-2xl font-bold text-white">{{ $mesa->name }}</span>

        @if($mesa->activeOrder && $mesa->activeOrder->cliente)
            <span
                class="mt-1 text-sm font-bold text-white bg-amber-600/70 rounded-full px-3 py-0.5 truncate max-w-full text-center leading-tight">
                {{ $mesa->activeOrder->cliente }}
            </span>
        @elseif($mesa->is_internal)
            <span
                class="mt-1 text-[9px] bg-purple-900/50 text-purple-200 px-1.5 py-0.5 rounded border border-purple-500/30 uppercase font-bold">Uso
                Interno</span>
        @endif

        @if ($mesa->status === 'ocupada')
            <span class="mt-2 text-xs bg-black bg-opacity-20 px-3 py-1 rounded-full font-bold">Ocupada</span>
        @else
            <span class="mt-2 text-xs bg-white bg-opacity-20 px-3 py-1 rounded-full font-bold text-amber-100">Abierta</span>
        @endif
    </a>
@endif