@extends('layouts.app')

@section('content')
    <div class="max-w-7xl mx-auto py-6 sm:px-6 lg:px-8" x-data="{
                                            activeZona: {{ (collect($zonas)->first()) ? collect($zonas)->first()->id : (collect($mesasGenerales)->count() > 0 ? 0 : 'null') }},
                                            mesaId: null,
                                            openMesa(mesa) {
                                                this.mesaId = mesa.id;
                                                this.$nextTick(() => {
                                                    this.$refs.autoOpenForm.submit();
                                                });
                                            }
                                        }">
        <h1 class="text-3xl font-bold text-gray-100 mb-6 font-serif">Mapa de Mesas</h1>

        <!-- Status Legend & Tabs -->
        <div class="flex flex-col md:flex-row md:items-end justify-between gap-6 mb-8 border-b border-gray-800 pb-4">
            <div class="flex space-x-6">
                <div class="flex items-center"><span
                        class="w-3 h-3 bg-green-500 rounded-full mr-2 shadow-sm shadow-green-900"></span> <span
                        class="text-sm font-medium text-gray-300">Libre</span></div>
                <div class="flex items-center"><span
                        class="w-3 h-3 bg-orange-500 rounded-full mr-2 shadow-sm shadow-orange-900"></span> <span
                        class="text-sm font-medium text-gray-300">Ocupada</span></div>
            </div>

            {{-- Zone Tabs --}}
            <div class="flex flex-wrap gap-2">
                @foreach ($zonas as $zona)
                    <button @click="activeZona = {{ $zona->id }}"
                        :class="activeZona == {{ $zona->id }} ? 'bg-amber-600 text-white shadow-lg' : 'bg-gray-800 text-gray-400 hover:bg-gray-700'"
                        class="px-4 py-2 rounded-lg font-bold transition-all duration-200 text-sm">
                        {{ $zona->nombre }}
                    </button>
                @endforeach

                @if (collect($mesasGenerales)->count() > 0)
                    <button @click="activeZona = 0"
                        :class="activeZona == 0 ? 'bg-amber-600 text-white shadow-lg' : 'bg-gray-800 text-gray-400 hover:bg-gray-700'"
                        class="px-4 py-2 rounded-lg font-bold transition-all duration-200 text-sm">
                        Otras / Sin Zona
                    </button>
                @endif
            </div>
        </div>

        <!-- Tables Grid Sections -->
        @foreach ($zonas as $zona)
            <div x-show="activeZona == {{ $zona->id }}" x-transition:enter="transition ease-out duration-300"
                x-transition:enter-start="opacity-0 transform scale-95"
                x-transition:enter-end="opacity-100 transform scale-100">
                <div class="grid grid-cols-2 md:grid-cols-4 lg:grid-cols-5 gap-6">
                    @foreach ($zona->mesas as $mesa)
                        @include('pos.partials.mesa_card', ['mesa' => $mesa])
                    @endforeach
                </div>
            </div>
        @endforeach

        @if (collect($mesasGenerales)->count() > 0)
            <div x-show="activeZona == 0" x-transition:enter="transition ease-out duration-300"
                x-transition:enter-start="opacity-0 transform scale-95"
                x-transition:enter-end="opacity-100 transform scale-100">
                <div class="grid grid-cols-2 md:grid-cols-4 lg:grid-cols-5 gap-6">
                    @foreach ($mesasGenerales as $mesa)
                        @include('pos.partials.mesa_card', ['mesa' => $mesa])
                    @endforeach
                </div>
            </div>
        @endif

        @if(collect($zonas)->isEmpty() && collect($mesasGenerales)->isEmpty())
            <div class="bg-gray-800/50 border-2 border-dashed border-gray-700 rounded-2xl p-12 text-center">
                <div class="text-5xl mb-4">🪑</div>
                <h3 class="text-xl font-bold text-gray-300">No hay mesas configuradas</h3>
                <p class="text-gray-500 mt-2">Ve a la gestión de mesas para agregar tu primera zona y mesas.</p>
                <a href="{{ route('admin.mesas.index') }}"
                    class="inline-block mt-6 px-6 py-2 bg-amber-600 hover:bg-amber-500 text-white rounded-lg font-bold">Configurar
                    Mesas</a>
            </div>
        @endif

        <!-- Hidden Auto-Open Form (opens table directly, no modal) -->
        <form x-ref="autoOpenForm" :action="'{{ url('/pos/table') }}/' + mesaId + '/open'" method="POST" class="hidden">
            @csrf
            <input type="hidden" name="cliente" value="">
        </form>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js" defer></script>
@endsection