@extends('layouts.app')

@section('content')
    <div class="max-w-4xl mx-auto py-12 px-6 overflow-y-auto h-full custom-scrollbar print:p-0">
        <div
            class="bg-gray-800 shadow-2xl rounded-xl border border-gray-700 overflow-hidden print:bg-white print:border-none print:shadow-none print:rounded-none">
            <!-- Header (Screen Only) -->
            <div class="bg-gray-900/50 p-6 border-b border-gray-700 flex justify-between items-center print:hidden">
                <div>
                    <h1 class="text-2xl font-bold text-white">Resumen de Arqueo #{{ $arqueo->id }}</h1>
                    <p class="text-gray-400 text-sm mt-1">Caja cerrada el {{ $arqueo->created_at->format('d/m/Y h:i A') }}
                        por
                        {{ $arqueo->user->name }}
                    </p>
                </div>
                <div class="flex gap-2">
                    <button onclick="window.print()"
                        class="bg-gray-700 hover:bg-gray-600 text-white px-4 py-2 rounded-lg font-bold flex items-center gap-2 transition-colors">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24"
                            stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z" />
                        </svg>
                        Imprimir
                    </button>
                    <a href="{{ route('admin.dashboard') }}"
                        class="bg-blue-600 hover:bg-blue-500 text-white px-4 py-2 rounded-lg font-bold transition-colors">
                        Finalizar
                    </a>
                </div>
            </div>

            <!-- Receipt Content -->
            <div class="p-8 space-y-8 print:p-4 print:space-y-4 print:text-black">
                <!-- Receipt Header (Print Only) -->
                <div class="hidden print:block text-center mb-6">
                    <h2 class="text-xl font-bold uppercase">Sukha Cigar Bar</h2>
                    <p class="text-sm">Arqueo de Caja #{{ $arqueo->id }}</p>
                    <p class="text-xs">{{ $arqueo->created_at->format('d/m/Y h:i A') }}</p>
                    <p class="text-xs">Cajero: {{ $arqueo->user->name }}</p>
                    <div class="border-b border-dashed border-black my-4"></div>
                </div>

                <!-- Comparison Grid -->
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6 print:block print:space-y-2">
                    <!-- Expected -->
                    <div
                        class="bg-gray-900/40 p-5 rounded-lg border border-gray-700 print:bg-white print:border-none print:p-0 print:flex print:justify-between">
                        <h3
                            class="text-gray-500 text-xs font-bold uppercase tracking-wider mb-2 print:text-black print:mb-0 print:normal-case print:text-sm">
                            Esperado (Sistema):</h3>
                        <p class="text-2xl font-bold text-white print:text-black print:text-sm">
                            ${{ number_format($arqueo->monto_sistema, 2) }}</p>
                    </div>

                    <!-- Physical -->
                    <div
                        class="bg-gray-900/40 p-5 rounded-lg border border-gray-700 print:bg-white print:border-none print:p-0 print:flex print:justify-between">
                        <h3
                            class="text-gray-500 text-xs font-bold uppercase tracking-wider mb-2 print:text-black print:mb-0 print:normal-case print:text-sm">
                            Real (Físico):</h3>
                        <p class="text-2xl font-bold text-amber-400 print:text-black print:text-sm">
                            ${{ number_format($arqueo->monto_fisico, 2) }}</p>
                    </div>

                    <!-- Difference -->
                    <div
                        class="p-5 rounded-lg border {{ $arqueo->diferencia >= 0 ? 'bg-green-900/20 border-green-900/50' : 'bg-red-900/20 border-red-900/50' }} print:bg-white print:border-none print:p-0 print:flex print:justify-between print:border-t print:border-dashed print:border-black print:pt-2">
                        <h3
                            class="{{ $arqueo->diferencia >= 0 ? 'text-green-500' : 'text-red-500' }} text-xs font-bold uppercase tracking-wider mb-2 print:text-black print:mb-0 print:normal-case print:text-sm print:font-bold">
                            Diferencia:</h3>
                        <p
                            class="text-2xl font-bold {{ $arqueo->diferencia >= 0 ? 'text-green-400' : 'text-red-400' }} print:text-black print:text-sm print:font-bold">
                            {{ $arqueo->diferencia > 0 ? '+' : '' }}{{ number_format($arqueo->diferencia, 2) }}
                        </p>
                    </div>
                </div>

                <div class="hidden print:block border-b border-dashed border-black my-4"></div>

                <!-- Digital Payments Breakdown -->
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 print:block print:space-y-2">
                    <div
                        class="bg-gray-900/40 p-5 rounded-lg border border-gray-700 print:bg-white print:border-none print:p-0 print:flex print:justify-between">
                        <h3
                            class="text-gray-500 text-xs font-bold uppercase tracking-wider mb-3 print:text-black print:mb-0 print:normal-case print:text-sm">
                            Ventas Tarjeta:</h3>
                        <p class="text-xl font-bold text-blue-400 print:text-black print:text-sm">
                            ${{ number_format($arqueo->monto_tarjeta, 2) }}</p>
                    </div>
                    <div
                        class="bg-gray-900/40 p-5 rounded-lg border border-gray-700 print:bg-white print:border-none print:p-0 print:flex print:justify-between">
                        <h3
                            class="text-gray-500 text-xs font-bold uppercase tracking-wider mb-3 print:text-black print:mb-0 print:normal-case print:text-sm">
                            Ventas Transferencia:</h3>
                        <p class="text-xl font-bold text-purple-400 print:text-black print:text-sm">
                            ${{ number_format($arqueo->monto_transferencia, 2) }}</p>
                    </div>
                    @php
                        $internalUse = $apertura->sales->where('is_internal', true)->sum('total');
                    @endphp
                    <div
                        class="bg-gray-900/40 p-5 rounded-lg border border-amber-500/20 md:col-span-2 print:bg-white print:border-none print:p-0 print:flex print:justify-between print:mt-2">
                        <h3
                            class="text-amber-500 text-xs font-bold uppercase tracking-wider mb-3 print:text-black print:mb-0 print:normal-case print:text-sm">
                            Consumo Interno (No afecta caja):</h3>
                        <p class="text-xl font-bold text-amber-500 print:text-black print:text-sm">
                            ${{ number_format($internalUse, 2) }}</p>
                    </div>
                </div>

                <div class="hidden print:block border-b border-dashed border-black my-4"></div>

                <!-- Denomination Breakdown -->
                @if($arqueo->denominaciones)
                    <div
                        class="bg-gray-900/40 p-6 rounded-lg border border-gray-700 print:bg-white print:border-none print:p-0">
                        <h3
                            class="text-gray-300 font-bold mb-4 flex items-center gap-2 print:text-black print:text-sm print:mb-2">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-amber-500 print:hidden" fill="none"
                                viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                            Desglose de Efectivo
                        </h3>
                        <div class="grid grid-cols-2 md:grid-cols-5 gap-4 print:block print:space-y-1">
                            @foreach($arqueo->denominaciones as $val => $qty)
                                @if($qty > 0)
                                    <div
                                        class="bg-gray-800 p-3 rounded text-center border border-gray-700/50 print:bg-white print:border-none print:p-0 print:flex print:justify-between print:text-xs">
                                        <div class="text-xs text-gray-500 font-bold print:text-black print:font-normal">${{ $val }} x
                                            {{ $qty }}
                                        </div>
                                        <div class="text-[10px] text-amber-500/80 mt-1 print:text-black print:text-xs print:mt-0">
                                            ${{ number_format($val * $qty) }}</div>
                                    </div>
                                @endif
                            @endforeach
                        </div>
                    </div>
                @endif

                <!-- Observations -->
                @if($arqueo->observaciones)
                    <div
                        class="bg-gray-900/40 p-6 rounded-lg border border-gray-700 print:bg-white print:border-none print:p-0 print:border-t print:border-dashed print:border-black print:pt-4">
                        <h3
                            class="text-gray-500 text-xs font-bold uppercase tracking-wider mb-2 print:text-black print:text-sm">
                            Observaciones:</h3>
                        <p class="text-gray-300 italic print:text-black print:text-xs print:not-italic">
                            {{ $arqueo->observaciones }}
                        </p>
                    </div>
                @endif

                <div class="hidden print:block text-center mt-8 pt-8 border-t border-dashed border-black">
                    <p class="text-xs">*** Fin del Reporte ***</p>
                </div>
            </div>
        </div>
    </div>

    <style>
        @media print {
            @page {
                size: 80mm auto;
                margin: 0;
            }

            body {
                background: white !important;
                margin: 0;
                padding: 0;
                width: 80mm;
            }

            .max-w-4xl {
                width: 80mm !important;
                max-width: 80mm !important;
                padding: 0 !important;
                margin: 0 !important;
                color: black !important;
            }

            .text-amber-400,
            .text-blue-400,
            .text-purple-400,
            .text-green-400,
            .text-red-400 {
                color: black !important;
                font-weight: bold;
            }
        }
    </style>
@endsection