@extends('layouts.app')

@section('content')
    <div class="max-w-md mx-auto py-12 px-6">
        <div class="bg-gray-800 shadow-xl rounded-lg p-8 border border-gray-700">
            <div class="text-center mb-8">
                <h1 class="text-3xl font-bold text-amber-500 mb-2">Apertura de Caja</h1>
                <p class="text-gray-400">Inicia sesión de caja para comenzar a operar</p>
            </div>

            @if($errors->any())
                <div class="bg-red-900 border border-red-700 text-red-200 px-4 py-3 rounded mb-4">
                    {{ $errors->first() }}
                </div>
            @endif

            <form action="{{ route('caja.open.post') }}" method="POST">
                @csrf
                <input type="hidden" name="caja_id" value="{{ $caja->id }}">

                <div class="mb-6">
                    <label class="block text-gray-300 text-sm font-bold mb-2">Caja Seleccionada</label>
                    <div class="p-3 bg-gray-700 rounded text-white font-mono">{{ $caja->name }}</div>
                </div>

                <div class="mb-6 grid grid-cols-2 gap-4">
                    <div>
                        <label for="fecha_inicio" class="block text-gray-300 text-sm font-bold mb-2">Fecha/Hora
                            Inicio</label>
                        <input type="datetime-local" name="fecha_inicio" id="fecha_inicio"
                            value="{{ now()->format('Y-m-d\TH:i') }}"
                            class="w-full bg-gray-900 border border-gray-600 rounded p-3 text-white focus:border-amber-500 outline-none"
                            required>
                    </div>
                    <div>
                        <label for="fecha_fin" class="block text-gray-300 text-sm font-bold mb-2">Fecha/Hora Fin</label>
                        <input type="datetime-local" name="fecha_fin" id="fecha_fin"
                            value="{{ now()->addHours(12)->format('Y-m-d\TH:i') }}"
                            class="w-full bg-gray-900 border border-gray-600 rounded p-3 text-white focus:border-amber-500 outline-none"
                            required>
                    </div>
                </div>

                <div class="mb-8">
                    <label for="monto_inicial" class="block text-gray-300 text-sm font-bold mb-2">Monto Inicial (Fondo de
                        Caja)</label>
                    <div class="relative">
                        <span class="absolute left-3 top-3 text-gray-400">$</span>
                        <input type="number" name="monto_inicial" id="monto_inicial" step="0.01"
                            class="w-full bg-gray-900 border border-gray-600 rounded pl-8 p-3 text-white text-lg focus:border-amber-500 focus:ring-1 focus:ring-amber-500 outline-none"
                            placeholder="0.00" required autofocus>
                    </div>
                </div>

                <button type="submit"
                    class="w-full bg-green-600 hover:bg-green-500 text-white font-bold py-3 rounded shadow-lg transition transform hover:scale-105">
                    Abrir Caja
                </button>
            </form>
        </div>
    </div>
@endsection