@extends('layouts.app')

@section('content')
    <div class="max-w-2xl mx-auto py-12 px-6">
        <div class="bg-gray-800 shadow-xl rounded-lg border border-gray-700">
            <div class="bg-red-900/20 p-6 border-b border-red-900/50">
                <h1 class="text-2xl font-bold text-red-400">Cierre de Caja (Arqueo)</h1>
                <p class="text-gray-400 text-sm mt-1">Ingresa el dinero físico contado en caja para finalizar la sesión.</p>
            </div>

            <div class="p-8">
                <div class="mb-8 p-4 bg-gray-900 rounded border border-gray-700">
                    <h3 class="text-gray-400 text-sm font-bold uppercase mb-2">Resumen del Sistema</h3>
                    <div class="flex justify-between items-end mb-3">
                        <div class="text-sm text-gray-500">Se espera en Efectivo:</div>
                        @php
                            $cashSales = $apertura->sales->where('payment_method', 'cash')->sum('total');
                            $cardSales = $apertura->sales->where('payment_method', 'card')->sum('total');
                            $transferSales = $apertura->sales->where('payment_method', 'transfer')->sum('total');
                            $expected = $apertura->monto_inicial + $cashSales;
                        @endphp
                        <div class="text-2xl font-bold text-white">${{ number_format($expected, 2) }}</div>
                    </div>
                    <div class="flex justify-between items-center text-sm border-t border-gray-800 pt-3">
                        <div class="text-gray-500">Ventas con Tarjeta:</div>
                        <div class="text-gray-300 font-medium">${{ number_format($cardSales, 2) }}</div>
                    </div>
                    <div class="flex justify-between items-center text-sm mt-1">
                        <div class="text-gray-500">Ventas por Transferencia:</div>
                        <div class="text-gray-300 font-medium">${{ number_format($transferSales, 2) }}</div>
                    </div>
                </div>

                <div x-data="{
                        denominaciones: {
                            '2000': 0, '1000': 0, '500': 0, '200': 0, '100': 0,
                            '50': 0, '25': 0, '10': 0, '5': 0, '1': 0
                        },
                        openTables: {{ $openTablesCount }},
                        showWarning: false,
                        get montoTotal() {
                            return Object.entries(this.denominaciones).reduce((acc, [val, qty]) => acc + (val * qty), 0);
                        },
                        handleClose(e) {
                            if (this.openTables > 0 && !this.showWarning) {
                                e.preventDefault();
                                this.showWarning = true;
                            }
                        }
                    }">
                    <form action="{{ route('caja.close.post') }}" method="POST" @submit="handleClose($event)"
                        x-ref="closeForm">
                        @csrf
                        <input type="hidden" name="apertura_id" value="{{ $apertura->id }}">

                        <h3 class="text-gray-300 text-sm font-bold uppercase mb-4 border-b border-gray-700 pb-2">Desglose de
                            Efectivo</h3>

                        <div class="grid grid-cols-2 gap-x-8 gap-y-4 mb-8">
                            <template x-for="val in ['2000', '1000', '500', '200', '100', '50', '25', '10', '5', '1']"
                                :key="val">
                                <div class="flex items-center justify-between bg-gray-900/50 p-2 rounded">
                                    <div class="text-gray-400 font-bold w-12" x-text="'$' + val"></div>
                                    <div class="flex items-center gap-2">
                                        <input type="number" :name="'denominaciones[' + val + ']'"
                                            x-model.number="denominaciones[val]" min="0"
                                            class="w-20 bg-gray-800 border border-gray-600 rounded p-1 text-center text-white focus:border-amber-500 outline-none">
                                        <div class="text-xs text-gray-500 w-24 text-right"
                                            x-text="'= $' + (val * (denominaciones[val] || 0)).toLocaleString()"></div>
                                    </div>
                                </div>
                            </template>
                        </div>

                        <div class="mb-6 p-4 bg-amber-900/20 border border-amber-900/50 rounded-lg">
                            <label for="monto_fisico" class="block text-amber-400 text-sm font-bold mb-2">Monto Físico Total
                                Calculado</label>
                            <div class="relative">
                                <span class="absolute left-3 top-3 text-amber-500 font-bold">$</span>
                                <input type="number" name="monto_fisico" id="monto_fisico" step="0.01"
                                    x-bind:value="montoTotal" readonly
                                    class="w-full bg-gray-900 border border-amber-900/50 rounded pl-8 p-3 text-white text-2xl font-bold outline-none"
                                    placeholder="0.00" required>
                            </div>
                            <p class="text-amber-500/70 text-xs mt-2 italic">* Este monto se calcula automáticamente basado
                                en el desglose superior.</p>
                        </div>

                        <div class="mb-8">
                            <label for="observaciones"
                                class="block text-gray-300 text-sm font-bold mb-2">Observaciones</label>
                            <textarea name="observaciones" id="observaciones" rows="3"
                                class="w-full bg-gray-900 border border-gray-600 rounded p-3 text-white focus:border-amber-500 outline-none"
                                placeholder="Notas sobre diferencias o incidencias..."></textarea>
                        </div>

                        <div class="flex gap-4">
                            <a href="{{ route('caja.operations') }}"
                                class="flex-1 bg-gray-600 hover:bg-gray-500 text-white font-bold py-3 rounded text-center">
                                Cancelar
                            </a>
                            <button type="submit"
                                class="flex-1 bg-red-600 hover:bg-red-500 text-white font-bold py-3 rounded shadow-lg">
                                Confirmar Cierre
                            </button>
                        </div>
                    </form>

                    {{-- Warning Modal --}}
                    <div x-show="showWarning"
                        class="fixed inset-0 z-50 flex items-center justify-center p-4 bg-black/80 backdrop-blur-sm"
                        x-transition.opacity x-cloak>
                        <div
                            class="bg-gray-800 rounded-2xl max-w-md w-full p-8 border border-red-500/30 shadow-2xl scale-up">
                            <div class="text-center mb-6">
                                <div
                                    class="bg-red-500/20 p-4 rounded-full w-16 h-16 flex items-center justify-center mx-auto mb-4">
                                    <i class="bi bi-exclamation-triangle text-3xl text-red-500"></i>
                                </div>
                                <h3 class="text-xl font-bold text-white mb-2">Mesas sin cobrar</h3>
                                <p class="text-gray-400">Existen <span class="text-red-400 font-bold"
                                        x-text="openTables"></span> mesas con productos pendientes. Si cierras la caja
                                    ahora, estas ventas no se reflejarán en este cierre.</p>
                                <p class="text-gray-300 font-bold mt-4">¿Desea continuar con el cierre de todas formas?</p>
                            </div>

                            <div class="flex gap-4">
                                <button @click="showWarning = false"
                                    class="flex-1 py-3 bg-gray-700 hover:bg-gray-600 text-white font-bold rounded-xl transition">
                                    No, Volver
                                </button>
                                <button @click="showWarning = false; $nextTick(() => $refs.closeForm.submit())"
                                    class="flex-1 py-3 bg-red-600 hover:bg-red-500 text-white font-bold rounded-xl shadow-lg shadow-red-900/20 transition">
                                    Sí, Cerrar Caja
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection