@extends('layouts.app')

@section('content')
    <div class="max-w-7xl mx-auto py-6 sm:px-6 lg:px-8">
        <div class="flex justify-between items-center mb-8">
            <div>
                <h1 class="text-3xl font-bold text-white font-serif">Diseñador de Menú Digital</h1>
                <p class="text-gray-400">Personaliza la experiencia visual de tus clientes vía QR</p>
            </div>
            <a href="{{ route('public.menu') }}" target="_blank"
                class="bg-gray-800 hover:bg-gray-700 text-amber-500 border border-amber-500/30 px-5 py-2.5 rounded-xl font-bold transition flex items-center gap-2">
                <i class="bi bi-eye"></i> Ver Menú Público
            </a>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
            <!-- Configuration Form -->
            <div class="bg-gray-800 rounded-2xl shadow-xl p-8 border border-gray-700">
                <h2 class="text-xl font-bold text-white mb-6 flex items-center gap-2">
                    <i class="bi bi-palette text-amber-500"></i> Identidad y Branding
                </h2>

                <form action="{{ route('admin.menu.save') }}" method="POST" class="space-y-6">
                    @csrf

                    <div>
                        <label class="block text-gray-400 text-xs font-bold uppercase tracking-widest mb-2">Color
                            Principal</label>
                        <div class="flex items-center gap-4">
                            <input type="color" name="primary_color" value="{{ $config->primary_color }}"
                                class="w-12 h-12 rounded-lg bg-gray-900 border-none cursor-pointer">
                            <input type="text" value="{{ $config->primary_color }}"
                                class="bg-gray-900 border border-gray-700 rounded-xl p-3 text-white w-32 text-center"
                                readonly>
                        </div>
                    </div>

                    <div>
                        <label class="block text-gray-400 text-xs font-bold uppercase tracking-widest mb-2">Mensaje de
                            Bienvenida (H1)</label>
                        <input type="text" name="welcome_message" value="{{ $config->welcome_message }}"
                            class="w-full bg-gray-900 border border-gray-700 rounded-xl p-4 text-white focus:border-amber-500 outline-none transition"
                            placeholder="Ej: Sukha Cigar Bar">
                    </div>

                    <div>
                        <label class="block text-gray-400 text-xs font-bold uppercase tracking-widest mb-2">Subtítulo /
                            Eslogan</label>
                        <input type="text" name="welcome_subtitle" value="{{ $config->welcome_subtitle }}"
                            class="w-full bg-gray-900 border border-gray-700 rounded-xl p-4 text-white focus:border-amber-500 outline-none transition"
                            placeholder="Ej: Premium Cigar Bar & Lounge">
                    </div>

                    <div>
                        <label class="block text-gray-400 text-xs font-bold uppercase tracking-widest mb-2">URL del Banner
                            (Imagen Superior)</label>
                        <input type="text" name="banner_url" value="{{ $config->banner_url }}"
                            class="w-full bg-gray-900 border border-gray-700 rounded-xl p-4 text-white focus:border-amber-500 outline-none transition"
                            placeholder="https://images.unsplash.com/...">
                        <p class="text-[10px] text-gray-500 mt-2">Recomendado: 1200x600px o similar.</p>
                    </div>

                    <div class="flex flex-col gap-4 pt-4 border-t border-gray-700">
                        <label class="flex items-center cursor-pointer group">
                            <div class="relative">
                                <input type="checkbox" name="show_prices" value="1" {{ $config->show_prices ? 'checked' : '' }} class="sr-only peer">
                                <div
                                    class="w-10 h-6 bg-gray-700 peer-focus:outline-none rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-amber-600">
                                </div>
                            </div>
                            <span
                                class="ml-3 text-sm font-bold text-gray-300 group-hover:text-amber-500 transition-colors">Mostrar
                                Precios en el Menú</span>
                        </label>

                        <label class="flex items-center cursor-pointer group">
                            <div class="relative">
                                <input type="checkbox" name="is_active" value="1" {{ $config->is_active ? 'checked' : '' }}
                                    class="sr-only peer">
                                <div
                                    class="w-10 h-6 bg-gray-700 peer-focus:outline-none rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-green-600">
                                </div>
                            </div>
                            <span
                                class="ml-3 text-sm font-bold text-gray-300 group-hover:text-green-500 transition-colors">Menú
                                Digital Activo</span>
                        </label>
                    </div>

                    <div class="pt-6">
                        <button type="submit"
                            class="w-full bg-amber-600 hover:bg-amber-500 text-white py-4 rounded-2xl font-bold shadow-xl shadow-amber-900/40 transition flex items-center justify-center gap-2">
                            <i class="bi bi-check-lg"></i> Guardar Cambios
                        </button>
                    </div>
                </form>
            </div>

            <!-- Preview Mockup -->
            <div class="flex flex-col items-center">
                <h2 class="text-xl font-bold text-gray-400 mb-6 uppercase tracking-widest self-start">Vista Previa (Móvil)
                </h2>

                <div
                    class="relative w-[320px] h-[640px] border-[12px] border-stone-900 rounded-[50px] shadow-2xl overflow-hidden bg-stone-950 ring-4 ring-gray-800">
                    <div class="absolute top-0 left-1/2 -translate-x-1/2 w-32 h-6 bg-stone-900 rounded-b-2xl z-50"></div>

                    <iframe src="{{ route('public.menu') }}"
                        class="w-full h-full border-none pointer-events-none origin-top scale-100"></iframe>

                    <div class="absolute bottom-6 left-1/2 -translate-x-1/2 w-20 h-1 bg-white/20 rounded-full z-50"></div>
                </div>

                <div class="mt-8 text-center bg-gray-900/50 p-6 rounded-3xl border border-gray-800 max-w-sm">
                    <div class="flex flex-col items-center">
                        <div class="bg-white p-3 rounded-2xl mb-4">
                            <img src="https://api.qrserver.com/v1/create-qr-code/?size=150x150&data={{ urlencode(route('public.menu')) }}"
                                alt="QR" class="w-32 h-32">
                        </div>
                        <p class="text-[10px] text-gray-400 leading-relaxed mb-4">
                            Escanea este código o usa la URL pública para acceder a tu menú desde cualquier dispositivo
                            móvil.
                        </p>
                        <div class="flex flex-col gap-2 w-full">
                            <div class="break-all text-[10px] text-amber-500 font-mono bg-black/30 p-2 rounded">
                                {{ route('public.menu') }}
                            </div>
                            <a href="https://api.qrserver.com/v1/create-qr-code/?size=1000x1000&data={{ urlencode(route('public.menu')) }}"
                                target="_blank" download="menu-qr.png"
                                class="inline-flex items-center justify-center px-4 py-2 bg-indigo-600 text-xs text-white rounded-xl font-bold hover:bg-indigo-500 transition-all shadow-lg shadow-indigo-900/40">
                                <i class="bi bi-download mr-2"></i> Descargar QR (Alta Calidad)
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection