@extends('layouts.app')

@section('content')
    <div class="max-w-4xl mx-auto py-6 sm:px-6 lg:px-8">
        <h1 class="text-3xl font-bold text-gray-100 mb-6">Editar Empleado: {{ $employee->name }}</h1>

        <div class="bg-gray-800 shadow rounded-lg p-6">
            <form action="{{ route('employees.update', $employee) }}" method="POST">
                @csrf
                @method('PUT')

                <div class="mb-4">
                    <label for="name" class="block text-gray-300 text-sm font-bold mb-2">Nombre Completo</label>
                    <input type="text" name="name" id="name" value="{{ $employee->name }}"
                        class="w-full bg-gray-700 border border-gray-600 rounded p-2 text-white placeholder-gray-400"
                        required>
                </div>

                <div class="mb-4">
                    <label for="email" class="block text-gray-300 text-sm font-bold mb-2">Email</label>
                    <input type="email" name="email" id="email" value="{{ $employee->email }}"
                        class="w-full bg-gray-700 border border-gray-600 rounded p-2 text-white placeholder-gray-400"
                        required>
                </div>

                <div class="mb-4">
                    <label for="role_id" class="block text-gray-300 text-sm font-bold mb-2">Rol</label>
                    <select name="role_id" id="role_id"
                        class="w-full bg-gray-700 border border-gray-600 rounded p-2 text-white">
                        @foreach($roles as $role)
                            <option value="{{ $role->id }}" {{ $employee->role_id == $role->id ? 'selected' : '' }}>
                                {{ $role->name }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="mb-4">
                    <label class="flex items-center">
                        <input type="checkbox" name="is_active" value="1" {{ $employee->is_active ? 'checked' : '' }}
                            class="form-checkbox h-5 w-5 text-green-600 bg-gray-700 border-gray-600 rounded">
                        <span class="ml-2 text-gray-300">Cuenta Activa</span>
                    </label>
                </div>

                <div class="border-t border-gray-700 pt-4 mt-6 mb-4">
                    <h3 class="text-lg font-medium text-gray-300 mb-2">Cambiar Contraseña (Opcional)</h3>
                    <div class="mb-4">
                        <label for="password" class="block text-gray-400 text-sm font-bold mb-2">Nueva Contraseña</label>
                        <input type="password" name="password" id="password"
                            class="w-full bg-gray-700 border border-gray-600 rounded p-2 text-white placeholder-gray-400">
                    </div>
                    <div class="mb-4">
                        <label for="password_confirmation" class="block text-gray-400 text-sm font-bold mb-2">Confirmar
                            Nueva Contraseña</label>
                        <input type="password" name="password_confirmation" id="password_confirmation"
                            class="w-full bg-gray-700 border border-gray-600 rounded p-2 text-white placeholder-gray-400">
                    </div>
                </div>

                <div class="border-t border-gray-700 pt-4 mt-2 mb-4">
                    <h3 class="text-lg font-medium text-gray-300 mb-1">PIN de Acceso Rápido</h3>
                    <p class="text-gray-500 text-xs mb-3">Permite al empleado iniciar sesión con un PIN de 4 dígitos. Deja
                        en blanco para eliminar el PIN actual.</p>
                    <div class="mb-4">
                        <label for="pin" class="block text-gray-400 text-sm font-bold mb-2">Nuevo PIN (4 dígitos)</label>
                        <input type="password" name="pin" id="pin" inputmode="numeric" maxlength="4"
                            class="w-full bg-gray-700 border border-gray-600 rounded p-2 text-white placeholder-gray-400 tracking-widest text-center text-xl"
                            placeholder="{{ $employee->hasPin() ? '••••  (ya tiene PIN)' : 'Sin PIN' }}">
                        @error('pin')
                            <p class="text-red-400 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>
                </div>

                <div class="flex justify-end gap-4">
                    <a href="{{ route('employees.index') }}"
                        class="bg-gray-600 hover:bg-gray-500 text-white font-bold py-2 px-4 rounded">Cancelar</a>
                    <button type="submit"
                        class="bg-green-600 hover:bg-green-500 text-white font-bold py-2 px-4 rounded">Actualizar
                        Empleado</button>
                </div>
            </form>
        </div>
    </div>
@endsection