<?php

namespace Database\Seeders;

use App\Models\Category;
use App\Models\Product;
use Illuminate\Database\Seeder;

class ProductSeeder extends Seeder
{
    public function run(): void
    {
        $catCigarros = Category::create(['name' => 'Cigarros Premium', 'type' => 'Cigarros']);
        $catBebidas = Category::create(['name' => 'Whiskies', 'type' => 'Bebidas']);

        Product::create([
            'category_id' => $catCigarros->id,
            'name' => 'Cohiba Siglo VI',
            'purchase_price' => 50.00,
            'sale_price' => 120.00,
            'stock' => 50,
            'min_stock' => 10,
        ]);

        Product::create([
            'category_id' => $catBebidas->id,
            'name' => 'Macallan 12',
            'purchase_price' => 200.00,
            'sale_price' => 450.00,
            'stock' => 12,
            'min_stock' => 5,
        ]);
    }
}
