<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        $zona = \App\Models\Zona::create([
            'nombre' => 'Venta Directa',
            'activa' => true,
            'orden' => 0,
        ]);

        \App\Models\Mesa::create([
            'name' => 'Venta Directa',
            'zona_id' => $zona->id,
            'status' => 'libre',
            'is_active' => true,
            'capacity' => 1,
            'is_internal' => false,
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        $zona = \App\Models\Zona::where('nombre', 'Venta Directa')->first();
        if ($zona) {
            \App\Models\Mesa::where('zona_id', $zona->id)->delete();
            $zona->delete();
        }
    }
};
