<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('business_configs', function (Blueprint $create) {
            $create->id();
            $create->string('business_name')->default('Sukha Cigar Bar & Lounge');
            $create->string('rnc')->nullable();
            $create->string('phone')->nullable();
            $create->text('address')->nullable();
            $create->string('logo_path')->nullable();
            $create->string('email')->nullable();
            $create->string('website')->nullable();
            $create->timestamps();
        });

        // Seed default config
        DB::table('business_configs')->insert([
            'business_name' => 'Sukha Cigar Bar & Lounge',
            'rnc' => '123-45678-9',
            'phone' => '(809) 555-0199',
            'address' => 'Av. Principal #123, Santo Domingo',
            'created_at' => now(),
            'updated_at' => now(),
        ]);
    }

    public function down(): void
    {
        Schema::dropIfExists('business_configs');
    }
};
