<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('menu_configs', function (Blueprint $table) {
            $table->id();
            $table->string('banner_url')->nullable();
            $table->string('logo_url')->nullable();
            $table->string('primary_color')->default('#b45309'); // Amber 700
            $table->string('welcome_message')->nullable();
            $table->string('welcome_subtitle')->nullable();
            $table->boolean('show_prices')->default(true);
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('menu_configs');
    }
};
