<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasColumn('mesas', 'is_internal')) {
            Schema::table('mesas', function (Blueprint $table) {
                $table->boolean('is_internal')->default(false)->after('is_active');
            });
        }

        if (!Schema::hasColumn('ordenes', 'is_internal')) {
            Schema::table('ordenes', function (Blueprint $table) {
                $table->boolean('is_internal')->default(false)->after('cliente');
            });
        }

        if (!Schema::hasColumn('sales', 'is_internal')) {
            Schema::table('sales', function (Blueprint $table) {
                $table->boolean('is_internal')->default(false)->after('orden_id');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('mesas', function (Blueprint $table) {
            $table->dropColumn('is_internal');
        });

        Schema::table('ordenes', function (Blueprint $table) {
            $table->dropColumn('is_internal');
        });

        Schema::table('sales', function (Blueprint $table) {
            $table->dropColumn('is_internal');
        });
    }
};
