<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('apertura_cajas', function (Blueprint $blueprint) {
            $blueprint->dateTime('fecha_inicio')->nullable()->after('monto_inicial');
            $blueprint->dateTime('fecha_fin')->nullable()->after('fecha_inicio');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('apertura_cajas', function (Blueprint $blueprint) {
            $blueprint->dropColumn(['fecha_inicio', 'fecha_fin']);
        });
    }
};
