<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('mesas', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // Mesa 1, Barra 1, VIP 1
            $table->integer('capacity')->default(4);
            $table->enum('status', ['libre', 'ocupada', 'reservada', 'mantenimiento'])->default('libre');
            $table->string('location')->nullable(); // Terraza, Salón, etc.
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('mesas');
    }
};
