<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('inventory_movements', function (Blueprint $table) {
            $table->id();
            $table->foreignId('product_id')->constrained('products');
            $table->foreignId('user_id')->constrained('users');
            $table->enum('type', ['entrada', 'salida', 'ajuste', 'venta']);
            $table->integer('quantity'); // Positive for entry, negative/positive depending on logic (usually stored absolute here and type defines direction, or signed. Let's use signed or handle logic in app. Let's use absolute quantity and type defines sign.)
            // Actually, for simplicity in aggregation, signed is easier, but standard is absolute + type.
            $table->integer('current_stock_snapshot'); // Stock AFTER the movement
            $table->string('reason')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('inventory_movements');
    }
};
