<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Sale extends Model
{
    use HasFactory;

    protected $fillable = [
        'apertura_caja_id',
        'orden_id',
        'user_id',
        'total',
        'discount',
        'payment_method',
        'amount_paid',
        'change_given',
        'is_internal',
    ];

    protected $casts = [
        'is_internal' => 'boolean',
    ];

    public function details()
    {
        return $this->hasMany(SaleDetail::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function aperturaCaja()
    {
        return $this->belongsTo(AperturaCaja::class);
    }
}
