<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    use HasFactory;

    protected $fillable = [
        'category_id',
        'name',
        'barcode',
        'purchase_price',
        'sale_price',
        'stock',
        'min_stock',
        'is_active',
        'type',
        'image_url',
    ];

    public function packageItems()
    {
        return $this->hasMany(PackageItem::class, 'package_id');
    }

    public function isBundle()
    {
        return $this->type === 'bundle';
    }

    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    public function movements()
    {
        return $this->hasMany(InventoryMovement::class);
    }
}
