<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OrdenDetalle extends Model
{
    use HasFactory;

    protected $table = 'orden_detalles'; // Custom table name

    protected $fillable = [
        'orden_id',
        'product_id',
        'cantidad',
        'precio_unitario',
        'subtotal',
        'observaciones',
        'estado'
    ];

    public function orden()
    {
        return $this->belongsTo(Orden::class);
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }
}
