<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Orden extends Model
{
    use HasFactory;

    protected $table = 'ordenes'; // Custom table name

    protected $fillable = [
        'mesa_id',
        'user_id',
        'fecha_apertura',
        'fecha_cierre',
        'estado',
        'pre_cuenta_generada',
        'subtotal',
        'impuesto',
        'total',
        'notas',
        'cliente',
        'accumulated_paid',
    ];

    protected $casts = [
        'fecha_apertura' => 'datetime',
        'fecha_cierre' => 'datetime',
        'pre_cuenta_generada' => 'boolean',
    ];

    public function mesa()
    {
        return $this->belongsTo(Mesa::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function detalles()
    {
        return $this->hasMany(OrdenDetalle::class);
    }
}
