<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Arqueo extends Model
{
    use HasFactory;

    protected $fillable = [
        'apertura_caja_id',
        'user_id',
        'monto_sistema',
        'monto_fisico',
        'monto_tarjeta',
        'monto_transferencia',
        'denominaciones',
        'diferencia',
        'observaciones',
    ];

    protected $casts = [
        'denominaciones' => 'array',
    ];

    public function apertura()
    {
        return $this->belongsTo(AperturaCaja::class, 'apertura_caja_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
