<?php

namespace App\Http\Controllers;

use App\Models\PlantillaImpresion;
use Illuminate\Http\Request;

class TemplateDesignerController extends Controller
{
    public function index(Request $request)
    {
        $tipo = $request->get('tipo', 'factura');
        $template = PlantillaImpresion::where('tipo', $tipo)->where('activa', true)->first();

        if (!$template || !isset($template->estructura_json['bloques']) || empty($template->estructura_json['bloques'])) {
            if (!$template) {
                $template = new PlantillaImpresion();
                $template->tipo = $tipo;
                $template->nombre = 'Plantilla ' . ucfirst($tipo);
            }
            if ($tipo === 'precuenta') {
                $template->estructura_json = [
                    'bloques' => [
                        ['id' => uniqid(), 'type' => 'header', 'active' => true, 'align' => 'center'],
                        ['id' => uniqid(), 'type' => 'text', 'active' => true, 'content' => '*** PRE-CUENTA ***', 'align' => 'center', 'bold' => true],
                        ['id' => uniqid(), 'type' => 'divider', 'active' => true, 'style' => 'dashed'],
                        ['id' => uniqid(), 'type' => 'data_field', 'active' => true, 'field' => 'mesa', 'label' => 'MESA: ', 'align' => 'left'],
                        ['id' => uniqid(), 'type' => 'data_field', 'active' => true, 'field' => 'mesero', 'label' => 'MESERO: ', 'align' => 'left'],
                        ['id' => uniqid(), 'type' => 'data_field', 'active' => true, 'field' => 'orden', 'label' => 'ORDEN: #', 'align' => 'left'],
                        ['id' => uniqid(), 'type' => 'data_field', 'active' => true, 'field' => 'fecha', 'label' => 'FECHA: ', 'align' => 'left'],
                        ['id' => uniqid(), 'type' => 'data_field', 'active' => true, 'field' => 'hora', 'label' => 'HORA: ', 'align' => 'left'],
                        ['id' => uniqid(), 'type' => 'divider', 'active' => true, 'style' => 'dashed'],
                        ['id' => uniqid(), 'type' => 'items_table', 'active' => true],
                        ['id' => uniqid(), 'type' => 'divider', 'active' => true, 'style' => 'dashed'],
                        ['id' => uniqid(), 'type' => 'totals', 'active' => true],
                        ['id' => uniqid(), 'type' => 'divider', 'active' => true, 'style' => 'dashed'],
                        ['id' => uniqid(), 'type' => 'text', 'active' => true, 'content' => 'Favor dirigirse a caja para pagar.', 'align' => 'center', 'bold' => false],
                    ]
                ];
            } else {
                $template->estructura_json = [
                    'bloques' => [
                        ['id' => uniqid(), 'type' => 'header', 'active' => true, 'align' => 'center'],
                        ['id' => uniqid(), 'type' => 'divider', 'active' => true, 'style' => 'dashed'],
                        ['id' => uniqid(), 'type' => 'data_field', 'active' => true, 'field' => 'ncf', 'label' => 'NCF: ', 'align' => 'left'],
                        ['id' => uniqid(), 'type' => 'data_field', 'active' => true, 'field' => 'id', 'label' => 'FACTURA: #', 'align' => 'left'],
                        ['id' => uniqid(), 'type' => 'data_field', 'active' => true, 'field' => 'fecha', 'label' => 'FECHA: ', 'align' => 'left'],
                        ['id' => uniqid(), 'type' => 'divider', 'active' => true, 'style' => 'dashed'],
                        ['id' => uniqid(), 'type' => 'items_table', 'active' => true],
                        ['id' => uniqid(), 'type' => 'divider', 'active' => true, 'style' => 'dashed'],
                        ['id' => uniqid(), 'type' => 'totals', 'active' => true],
                        ['id' => uniqid(), 'type' => 'divider', 'active' => true, 'style' => 'dashed'],
                        ['id' => uniqid(), 'type' => 'text', 'active' => true, 'content' => '¡GRACIAS POR SU PREFERENCIA!', 'align' => 'center', 'bold' => true],
                        ['id' => uniqid(), 'type' => 'text', 'active' => true, 'content' => '@Sukhacigarbar', 'align' => 'center', 'bold' => false],
                        ['id' => uniqid(), 'type' => 'qr_code', 'active' => true, 'align' => 'center'],
                        ['id' => uniqid(), 'type' => 'text', 'active' => true, 'content' => 'No se aceptan devoluciones.', 'align' => 'center', 'bold' => false, 'font_size' => 'small'],
                    ]
                ];
            }
        }

        return view('admin.templates.designer', compact('template'));
    }

    public function save(Request $request)
    {
        $validated = $request->validate([
            'id' => 'nullable|exists:plantillas_impresion,id',
            'nombre' => 'required|string',
            'tipo' => 'required|in:factura,precuenta',
            'estructura_json' => 'required|array',
        ]);

        // Inactivate other templates of the same type
        PlantillaImpresion::where('tipo', $request->tipo)->update(['activa' => false]);

        $template = PlantillaImpresion::updateOrCreate(
            ['id' => $request->id],
            array_merge($validated, ['activa' => true])
        );

        return response()->json(['success' => true, 'template' => $template]);
    }
}
