<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\Mesa;
use App\Models\Orden;
use App\Models\Product;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class TableController extends Controller
{
    public function index()
    {
        $zonas = \App\Models\Zona::with([
            'mesas' => function ($q) {
                $q->where('is_active', true);
            }
        ])->where('activa', true)->orderBy('orden')->get();

        // Fallback if no zones exist
        $mesasGenerales = \App\Models\Mesa::whereNull('zona_id')->where('is_active', true)->get();

        return view('pos.map', compact('zonas', 'mesasGenerales'));
    }

    // API method to get fresh status
    public function status()
    {
        return response()->json(Mesa::with('activeOrder')->get());
    }

    public function show(Mesa $mesa)
    {
        // View for a specific table's order
        $mesa->load('activeOrder.detalles.product');

        // Products for adding items (only active and in stock)
        $categories = Category::with([
            'products' => function ($q) {
                $q->where('is_active', true);
            }
        ])->get();

        return view('pos.table-order', compact('mesa', 'categories'));
    }

    public function open(Mesa $mesa, Request $request)
    {
        // ... Check if there's already an active order
        if ($mesa->activeOrder) {
            return redirect()->route('pos.table.show', $mesa);
        }

        if ($mesa->status !== 'libre') {
            return redirect()->route('pos.table.show', $mesa);
        }

        // Open Table Logic
        DB::transaction(function () use ($mesa, $request) {
            Orden::create([
                'mesa_id' => $mesa->id,
                'user_id' => Auth::id(),
                'estado' => 'abierta',
                'fecha_apertura' => now(),
                'cliente' => $request->cliente,
            ]);
        });

        return redirect()->route('pos.table.show', $mesa);
    }
}
