<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\MenuConfig;
use Illuminate\Http\Request;

class PublicMenuController extends Controller
{
    public function index()
    {
        $config = MenuConfig::first() ?? new MenuConfig([
            'primary_color' => '#b45309',
            'welcome_message' => 'Bienvenidos a Sukha',
            'welcome_subtitle' => 'Cigar Bar & Lounge',
            'show_prices' => true
        ]);

        $categories = Category::with([
            'products' => function ($q) {
                $q->where('is_active', true)
                    ->where('type', '!=', 'bundle')
                    ->where('stock', '>', 0)
                    ->with('packageItems.product');
            }
        ])->whereHas('products', function ($q) {
            $q->where('is_active', true)->where('type', '!=', 'bundle')->where('stock', '>', 0);
        })->get();

        $combos = \App\Models\Product::where('is_active', true)
            ->where('type', 'bundle')
            ->where('stock', '>', 0)
            ->with('packageItems.product')
            ->get();

        return view('public.menu', compact('categories', 'combos', 'config'));
    }
}
