<?php

namespace App\Http\Controllers;

use App\Models\MenuConfig;
use Illuminate\Http\Request;

class MenuConfigController extends Controller
{
    public function index()
    {
        $config = MenuConfig::first() ?: MenuConfig::create([
            'primary_color' => '#b45309',
            'welcome_message' => 'Bienvenidos a Sukha',
            'welcome_subtitle' => 'Cigar Bar & Lounge',
            'show_prices' => true
        ]);

        return view('admin.menu.designer', compact('config'));
    }

    public function save(Request $request)
    {
        $request->validate([
            'primary_color' => 'required|string',
            'welcome_message' => 'nullable|string|max:255',
            'welcome_subtitle' => 'nullable|string|max:255',
            'banner_url' => 'nullable|string',
            'show_prices' => 'boolean'
        ]);

        $config = MenuConfig::first() ?: new MenuConfig();
        $config->fill([
            'primary_color' => $request->primary_color,
            'welcome_message' => $request->welcome_message,
            'welcome_subtitle' => $request->welcome_subtitle,
            'banner_url' => $request->banner_url,
            'show_prices' => $request->has('show_prices'),
            'is_active' => $request->has('is_active', true)
        ]);
        $config->save();

        return back()->with('success', 'Configuración del menú digital actualizada.');
    }
}
